/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.moofluids;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.portingdeadmods.moofluids.Utils;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.server.command.ConfigCommand;

@EventBusSubscriber(modid="moofluids")
public final class MFCommands {
    @SubscribeEvent
    public static void onCommandRegister(RegisterCommandsEvent event) {
        MFCommands.dumpFluidCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        ConfigCommand.register((CommandDispatcher)event.getDispatcher());
    }

    private static void dumpFluidCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"moofluids").then(Commands.literal((String)"getAllExistingFluids").executes(commandContext -> MFCommands.dumpAllExistingFluids((CommandSourceStack)commandContext.getSource()))));
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"moofluids").then(Commands.literal((String)"getAllCowFluids").executes(commandContext -> MFCommands.dumpAllCowFluids((CommandSourceStack)commandContext.getSource()))));
    }

    private static int dumpAllExistingFluids(CommandSourceStack source) {
        List<ResourceLocation> fluids = BuiltInRegistries.FLUID.stream().map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.FLUID).getKey(arg_0)).toList();
        if (source.getPlayer() != null) {
            source.getPlayer().sendSystemMessage((Component)Component.literal((String)("Existing Fluids: " + String.valueOf(fluids))));
        } else {
            source.sendSystemMessage((Component)Component.literal((String)("Existing Fluids: " + String.valueOf(fluids))));
        }
        return 1;
    }

    private static int dumpAllCowFluids(CommandSourceStack source) {
        List<ResourceLocation> fluids = Utils.getFluids().stream().map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.FLUID).getKey(arg_0)).toList();
        if (source.getPlayer() != null) {
            source.getPlayer().sendSystemMessage((Component)Component.literal((String)("Cow fluids: " + String.valueOf(fluids))));
        } else {
            source.sendSystemMessage((Component)Component.literal((String)("Cow fluids: " + String.valueOf(fluids))));
        }
        return 1;
    }
}

