/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.moofluids.compat.jei;

import com.portingdeadmods.moofluids.entity.FluidCow;
import java.util.Optional;
import mezz.jei.api.gui.handlers.IGlobalGuiHandler;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.runtime.IClickableIngredient;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.fluids.FluidStack;

public class FluidCowJeiGuiHandler
implements IGlobalGuiHandler {
    private static IJeiRuntime jeiRuntime;

    public static void setJeiRuntime(IJeiRuntime runtime) {
        jeiRuntime = runtime;
    }

    public Optional<IClickableIngredient<?>> getClickableIngredientUnderMouse(double mouseX, double mouseY) {
        FluidCow fluidCow;
        Fluid fluid;
        EntityHitResult entityHitResult;
        Entity entity;
        if (jeiRuntime == null) {
            return Optional.empty();
        }
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.level == null || minecraft.player == null) {
            return Optional.empty();
        }
        HitResult hitResult = minecraft.hitResult;
        if (hitResult instanceof EntityHitResult && (entity = (entityHitResult = (EntityHitResult)hitResult).getEntity()) instanceof FluidCow && (fluid = (fluidCow = (FluidCow)entity).getFluid()) != null && fluid != Fluids.EMPTY) {
            FluidStack fluidStack = new FluidStack(fluid, 1000);
            IIngredientManager ingredientManager = jeiRuntime.getIngredientManager();
            ITypedIngredient typedIngredient = ingredientManager.createTypedIngredient((IIngredientType)NeoForgeTypes.FLUID_STACK, (Object)fluidStack).orElse(null);
            if (typedIngredient != null) {
                int screenX = (int)mouseX;
                int screenY = (int)mouseY;
                Rect2i area = new Rect2i(screenX - 8, screenY - 8, 16, 16);
                Optional clickableIngredient = ingredientManager.createClickableIngredient((IIngredientType)NeoForgeTypes.FLUID_STACK, (Object)fluidStack, area, true);
                return clickableIngredient.map(ingredient -> ingredient);
            }
        }
        return Optional.empty();
    }
}

