/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.block.component;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.customization.CustomizationRegistries;
import snownee.kiwi.customization.block.KBlockSettings;
import snownee.kiwi.customization.block.behavior.BlockBehaviorRegistry;

public interface KBlockComponent {
    public static final Codec<KBlockComponent> CODEC = Codec.lazyInitialized(() -> CustomizationRegistries.BLOCK_COMPONENT.byNameCodec().dispatch(KBlockComponent::type, Type::codec));

    public Type<?> type();

    public void injectProperties(Block var1, StateDefinition.Builder<Block, BlockState> var2);

    public BlockState registerDefaultState(BlockState var1);

    @Nullable
    default public BlockState getStateForPlacement(KBlockSettings settings, BlockState state, BlockPlaceContext context) {
        return state;
    }

    default public BlockState updateShape(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pPos, BlockPos pNeighborPos) {
        return pState;
    }

    default public BlockState rotate(BlockState pState, Rotation pRotation) {
        return pState;
    }

    default public BlockState mirror(BlockState pState, Mirror pMirror) {
        return pState;
    }

    default public boolean useShapeForLightOcclusion(BlockState pState) {
        return false;
    }

    default public boolean hasAnalogOutputSignal() {
        return false;
    }

    default public int getAnalogOutputSignal(BlockState state) {
        return 0;
    }

    default public void addBehaviors(BlockBehaviorRegistry registry) {
    }

    @Nullable
    default public Boolean canBeReplaced(BlockState blockState, BlockPlaceContext context) {
        return null;
    }

    @Nullable
    default public Direction getHorizontalFacing(BlockState blockState) {
        return null;
    }

    public record Type<T extends KBlockComponent>(MapCodec<T> codec) {
        @Override
        public String toString() {
            return "KBlockComponent.Type[" + String.valueOf(CustomizationRegistries.BLOCK_COMPONENT.getKey((Object)this)) + "]";
        }
    }
}

