/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.shape;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.shapes.Shapes;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.Kiwi;
import snownee.kiwi.customization.shape.BakingContext;
import snownee.kiwi.customization.shape.ShapeGenerator;
import snownee.kiwi.customization.shape.ShapeRef;
import snownee.kiwi.customization.shape.UnbakedShape;
import snownee.kiwi.loader.Platform;

public class ShapeStorage {
    private final ImmutableMap<ResourceLocation, ShapeGenerator> shapes;
    private final Map<Pair<ShapeGenerator, Object>, ShapeGenerator> transformed = Maps.newHashMap();

    public ShapeStorage(Map<ResourceLocation, ShapeGenerator> shapes) {
        this.shapes = ImmutableMap.copyOf(shapes);
    }

    @Nullable
    public ShapeGenerator get(ResourceLocation id) {
        return (ShapeGenerator)this.shapes.get((Object)id);
    }

    public static ShapeStorage reload(Supplier<Map<ResourceLocation, UnbakedShape>> shapesSupplier) {
        HashMap shapes = Platform.isDataGen() ? Maps.newHashMap() : (Map)shapesSupplier.get();
        shapes.put(ResourceLocation.withDefaultNamespace((String)"empty"), new UnbakedShape.Inlined(Shapes.empty()));
        shapes.put(ResourceLocation.withDefaultNamespace((String)"block"), new UnbakedShape.Inlined(Shapes.block()));
        BakingContext.Impl context = new BakingContext.Impl(shapes);
        LinkedHashSet refs = Sets.newLinkedHashSet();
        List unresolved = shapes.entrySet().stream().map(entry -> {
            UnbakedShape unbakedShape = (UnbakedShape)entry.getValue();
            Set<ShapeRef> dependencies = ShapeStorage.collectDependencies(unbakedShape).filter($ -> $ != unbakedShape).filter(ShapeRef.class::isInstance).map(ShapeRef.class::cast).collect(Collectors.toSet());
            if (dependencies.isEmpty()) {
                context.bake((ResourceLocation)entry.getKey(), unbakedShape);
                return null;
            }
            return new UnresolvedEntry((ResourceLocation)entry.getKey(), unbakedShape, dependencies);
        }).filter(Objects::nonNull).filter(entry -> {
            boolean success = true;
            for (ShapeRef ref : entry.dependencies) {
                if (shapes.containsKey(ref.id())) continue;
                Kiwi.LOGGER.error("Shape %s depends on %s, but it's not found".formatted(entry.key, ref.id()));
                success = false;
            }
            if (success) {
                refs.addAll(entry.dependencies);
            }
            return success;
        }).collect(Collectors.toCollection(LinkedList::new));
        while (!unresolved.isEmpty()) {
            boolean changed = false;
            refs.removeIf(ref -> ref.bindValue(context));
            Iterator iterator = unresolved.iterator();
            while (iterator.hasNext()) {
                UnresolvedEntry entry2 = (UnresolvedEntry)iterator.next();
                Set<ShapeRef> dependencies = entry2.dependencies;
                if (!dependencies.stream().allMatch(ShapeRef::isResolved)) continue;
                context.bake(entry2.key, entry2.unbakedShape);
                iterator.remove();
                changed = true;
            }
            if (changed) continue;
            Kiwi.LOGGER.error("Failed to resolve shapes: %s".formatted(unresolved.stream().map(entry -> entry.key.toString()).collect(Collectors.joining(", "))));
            break;
        }
        return new ShapeStorage(context.byId);
    }

    private static Stream<UnbakedShape> collectDependencies(UnbakedShape shape) {
        return Stream.concat(Stream.of(shape), shape.dependencies().flatMap(ShapeStorage::collectDependencies));
    }

    public void forEach(BiConsumer<? super ResourceLocation, ? super ShapeGenerator> action) {
        this.shapes.forEach(action);
    }

    public ShapeGenerator transform(ShapeGenerator shape, Object key, UnaryOperator<ShapeGenerator> factory) {
        Pair pair = Pair.of((Object)shape, (Object)key);
        if (this.transformed.containsKey(pair)) {
            return this.transformed.get(pair);
        }
        ShapeGenerator result = (ShapeGenerator)factory.apply(shape);
        this.transformed.put((Pair<ShapeGenerator, Object>)pair, result);
        return result;
    }

    private record UnresolvedEntry(ResourceLocation key, UnbakedShape unbakedShape, Set<ShapeRef> dependencies) {
    }
}

