/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.loader;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.modscan.ModAnnotation;
import net.neoforged.neoforgespi.language.IModFileInfo;
import net.neoforged.neoforgespi.language.ModFileScanData;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;
import snownee.kiwi.KiwiAnnotationData;
import snownee.kiwi.KiwiModule;
import snownee.kiwi.build.KiwiMetadata;
import snownee.kiwi.build.KiwiMetadataParser;
import snownee.kiwi.config.KiwiConfig;
import snownee.kiwi.network.KiwiPacket;

public record NeoDevEnvMetadataLoader(String modId) implements Function<KiwiMetadataParser, KiwiMetadata>
{
    @Override
    @Nullable
    public KiwiMetadata apply(KiwiMetadataParser parser) {
        IModFileInfo modFileInfo = ModList.get().getModFileById(this.modId);
        if (modFileInfo == null) {
            return null;
        }
        Type KIWI_MODULE = Type.getType(KiwiModule.class);
        Type KIWI_CONFIG = Type.getType(KiwiConfig.class);
        Type KIWI_PACKET = Type.getType(KiwiPacket.class);
        Type OPTIONAL_MODULE = Type.getType(KiwiModule.Optional.class);
        Type LOADING_CONDITION = Type.getType(KiwiModule.LoadingCondition.class);
        HashMap map = Maps.newHashMap();
        map.put("conditions", Lists.newArrayList());
        map.put("optionals", Lists.newArrayList());
        map.put("modules", Lists.newArrayList());
        map.put("packets", Lists.newArrayList());
        map.put("configs", Lists.newArrayList());
        for (ModFileScanData.AnnotationData annotationData : modFileInfo.getFile().getScanResult().getAnnotations()) {
            Type annotationType = annotationData.annotationType();
            if (KIWI_MODULE.equals((Object)annotationType)) {
                ((List)map.get("modules")).add(NeoDevEnvMetadataLoader.map(annotationData));
                continue;
            }
            if (KIWI_CONFIG.equals((Object)annotationType)) {
                ((List)map.get("configs")).add(NeoDevEnvMetadataLoader.map(annotationData));
                continue;
            }
            if (OPTIONAL_MODULE.equals((Object)annotationType)) {
                ((List)map.get("optionals")).add(NeoDevEnvMetadataLoader.map(annotationData));
                continue;
            }
            if (LOADING_CONDITION.equals((Object)annotationType)) {
                KiwiAnnotationData mapped = NeoDevEnvMetadataLoader.map(annotationData);
                String methodName = annotationData.memberName();
                int p = methodName.indexOf(40);
                if (p <= 0) {
                    throw new IllegalArgumentException();
                }
                methodName = methodName.substring(0, p);
                mapped.getData().put("method", methodName);
                ((List)map.get("conditions")).add(mapped);
                continue;
            }
            if (!KIWI_PACKET.equals((Object)annotationType)) continue;
            ((List)map.get("packets")).add(NeoDevEnvMetadataLoader.map(annotationData));
        }
        return new KiwiMetadata(map, false);
    }

    private static KiwiAnnotationData map(ModFileScanData.AnnotationData data) {
        HashMap annotationData = Maps.newHashMap();
        for (Map.Entry e : data.annotationData().entrySet()) {
            if (e.getValue() instanceof ModAnnotation.EnumHolder) {
                annotationData.put((String)e.getKey(), ((ModAnnotation.EnumHolder)e.getValue()).value());
                continue;
            }
            annotationData.put((String)e.getKey(), e.getValue());
        }
        KiwiAnnotationData kiwiAnnotationData = new KiwiAnnotationData();
        kiwiAnnotationData.setTarget(data.clazz().getClassName());
        kiwiAnnotationData.setData(annotationData);
        return kiwiAnnotationData;
    }
}

