/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.api;

import codechicken.enderstorage.api.Frequency;
import codechicken.enderstorage.manager.EnderStorageManager;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;

public abstract class AbstractEnderStorage {
    public final EnderStorageManager manager;
    public final Frequency freq;
    private boolean dirty;
    private int changeCount;

    public AbstractEnderStorage(EnderStorageManager manager, Frequency freq) {
        this.manager = manager;
        this.freq = freq;
    }

    public void setDirty() {
        if (this.manager.client) {
            return;
        }
        if (!this.dirty) {
            this.dirty = true;
            this.manager.requestSave(this);
        }
        ++this.changeCount;
    }

    public void setClean() {
        this.dirty = false;
    }

    public int getChangeCount() {
        return this.changeCount;
    }

    public abstract void clearStorage();

    public abstract String type();

    public abstract CompoundTag saveToTag(HolderLookup.Provider var1);

    public abstract void loadFromTag(CompoundTag var1, HolderLookup.Provider var2);
}

