/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.torchmaster.logic.entityblocking.megatorch;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.xalcon.torchmaster.logic.entityblocking.IEntityBlockingLight;
import net.xalcon.torchmaster.logic.entityblocking.ILightSerializer;
import net.xalcon.torchmaster.logic.entityblocking.megatorch.MegatorchEntityBlockingLight;

public class MegatorchSerializer
implements ILightSerializer {
    public static final String SERIALIZER_KEY = "megatorch";
    public static final MegatorchSerializer INSTANCE = new MegatorchSerializer();

    private MegatorchSerializer() {
    }

    @Override
    public CompoundTag serializeLight(IEntityBlockingLight light) {
        if (light == null) {
            throw new IllegalArgumentException("Unable to serialize null");
        }
        if (!(light instanceof MegatorchEntityBlockingLight)) {
            throw new IllegalArgumentException("Unable to serialize '" + light.getClass().getCanonicalName() + "', expected '" + MegatorchEntityBlockingLight.class.getCanonicalName() + "'");
        }
        MegatorchEntityBlockingLight megatorchLight = (MegatorchEntityBlockingLight)light;
        CompoundTag nbt = new CompoundTag();
        nbt.put("pos", NbtUtils.writeBlockPos((BlockPos)megatorchLight.getPos()));
        return nbt;
    }

    @Override
    public Optional<IEntityBlockingLight> deserializeLight(CompoundTag nbt) {
        Optional pos = NbtUtils.readBlockPos((CompoundTag)nbt, (String)"pos");
        return pos.map(MegatorchEntityBlockingLight::new);
    }

    @Override
    public String getSerializerKey() {
        return SERIALIZER_KEY;
    }
}

