/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.registry;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.BalmEvents;
import net.blay09.mods.balm.api.event.client.RecipesUpdatedEvent;
import net.blay09.mods.balm.api.event.server.ServerReloadFinishedEvent;
import net.blay09.mods.balm.api.event.server.ServerStartedEvent;
import net.blay09.mods.cookingforblockheads.CookingForBlockheadsConfig;
import net.blay09.mods.cookingforblockheads.api.ISortButton;
import net.blay09.mods.cookingforblockheads.api.KitchenRecipeGroup;
import net.blay09.mods.cookingforblockheads.api.KitchenRecipeHandler;
import net.blay09.mods.cookingforblockheads.tag.ModItemTags;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;

public class CookingForBlockheadsRegistry {
    private static final Multimap<ResourceLocation, RecipeHolder<Recipe<?>>> recipesByItemId = ArrayListMultimap.create();
    private static final Multimap<ResourceLocation, RecipeHolder<Recipe<?>>> recipesByGroup = ArrayListMultimap.create();
    private static final List<ISortButton> sortButtons = new ArrayList<ISortButton>();
    private static final Map<ItemStack, Integer> ovenFuelItems = new HashMap<ItemStack, Integer>();
    private static final Map<Class<? extends Recipe<?>>, KitchenRecipeHandler<? extends Recipe<?>>> kitchenRecipeHandlers = new HashMap();

    public static void initialize(BalmEvents events) {
        events.onEvent(RecipesUpdatedEvent.class, event -> CookingForBlockheadsRegistry.reload(event.getRecipeManager(), event.getRegistryAccess()));
        events.onEvent(ServerReloadFinishedEvent.class, event -> CookingForBlockheadsRegistry.reload(event.getServer().getRecipeManager(), (RegistryAccess)event.getServer().registryAccess()));
        events.onEvent(ServerStartedEvent.class, event -> CookingForBlockheadsRegistry.reload(event.getServer().getRecipeManager(), (RegistryAccess)event.getServer().registryAccess()));
    }

    private static void reload(RecipeManager recipeManager, RegistryAccess registryAccess) {
        recipesByItemId.clear();
        CookingForBlockheadsRegistry.loadRecipesByType(recipeManager, registryAccess, RecipeType.CRAFTING);
        CookingForBlockheadsRegistry.loadRecipesByType(recipeManager, registryAccess, RecipeType.SMELTING);
    }

    private static <C extends RecipeInput, T extends Recipe<C>> void loadRecipesByType(RecipeManager recipeManager, RegistryAccess registryAccess, RecipeType<T> recipeType) {
        for (RecipeHolder recipe : recipeManager.getAllRecipesFor(recipeType)) {
            ItemStack resultItem;
            if (!CookingForBlockheadsRegistry.isEligibleRecipe(recipe) || !CookingForBlockheadsRegistry.isEligibleResultItem(resultItem = recipe.value().getResultItem((HolderLookup.Provider)registryAccess))) continue;
            ResourceLocation itemId = Balm.getRegistries().getKey(resultItem.getItem());
            recipesByItemId.put((Object)itemId, (Object)recipe);
            List<KitchenRecipeGroup> groups = CookingForBlockheadsRegistry.getGroups();
            block1: for (KitchenRecipeGroup group : groups) {
                for (Ingredient ingredient : group.getChildren()) {
                    if (!ingredient.test(resultItem)) continue;
                    ResourceLocation groupItemId = Balm.getRegistries().getKey(group.getParentItem());
                    recipesByGroup.put((Object)groupItemId, (Object)recipe);
                    continue block1;
                }
            }
        }
    }

    public static List<KitchenRecipeGroup> getGroups() {
        return List.of();
    }

    private static boolean isEligibleResultItem(ItemStack itemStack) {
        if (itemStack.is(ModItemTags.EXCLUDED)) {
            return false;
        }
        return itemStack.has(DataComponents.FOOD) || itemStack.is(ModItemTags.FOODS) || itemStack.is(ModItemTags.INGREDIENTS);
    }

    private static <T extends RecipeInput> boolean isEligibleRecipe(RecipeHolder<? extends Recipe<T>> recipe) {
        return !CookingForBlockheadsConfig.getActive().excludedRecipes.contains(recipe.id());
    }

    public static <C extends RecipeInput, T extends Recipe<C>> void registerKitchenRecipeHandler(Class<T> recipeType, KitchenRecipeHandler<T> handler) {
        kitchenRecipeHandlers.put(recipeType, handler);
    }

    public static <T extends Recipe<?>, V extends KitchenRecipeHandler<T>> V getRecipeWorkshopHandler(T recipe) {
        for (Class<Recipe<?>> handlerClass : kitchenRecipeHandlers.keySet()) {
            if (!handlerClass.isAssignableFrom(recipe.getClass())) continue;
            return (V)kitchenRecipeHandlers.get(handlerClass);
        }
        return (V)kitchenRecipeHandlers.get(recipe.getClass());
    }

    public static void addSortButton(ISortButton nameSortButton) {
        sortButtons.add(nameSortButton);
    }

    public static Collection<ISortButton> getSortButtons() {
        return sortButtons;
    }

    public static void addOvenFuel(ItemStack fuelItem, int fuelTime) {
        ovenFuelItems.put(fuelItem, fuelTime);
    }

    public static int getOvenFuelTime(ItemStack itemStack) {
        for (Map.Entry<ItemStack, Integer> entry : ovenFuelItems.entrySet()) {
            if (!ItemStack.isSameItem((ItemStack)entry.getKey(), (ItemStack)itemStack)) continue;
            return entry.getValue();
        }
        return 0;
    }

    public static Collection<RecipeHolder<Recipe<?>>> getRecipesFor(ItemStack resultItem) {
        ResourceLocation itemId = Balm.getRegistries().getKey(resultItem.getItem());
        return recipesByItemId.get((Object)itemId);
    }

    public static Collection<? extends RecipeHolder<Recipe<?>>> getRecipesInGroup(ItemStack resultItem) {
        ResourceLocation itemId = Balm.getRegistries().getKey(resultItem.getItem());
        return recipesByGroup.get((Object)itemId);
    }

    public static Multimap<ResourceLocation, RecipeHolder<Recipe<?>>> getRecipesByItemId() {
        return recipesByItemId;
    }
}

