/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.client.screen.widget.buttons;

import java.util.function.Supplier;
import net.creeperhost.polylib.client.screen.widget.buttons.PolyButton;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class ButtonString
extends PolyButton {
    private final Supplier<Component> displayGetter;
    private final RenderPlace renderPlace;

    public ButtonString(int xPos, int yPos, int width, int height, Supplier<Component> displayGetter, RenderPlace renderPlace, Button.OnPress onPress) {
        super(xPos, yPos, width, height, displayGetter.get(), onPress, DEFAULT_NARRATION);
        this.displayGetter = displayGetter;
        this.renderPlace = renderPlace;
    }

    public ButtonString(int xPos, int yPos, int width, int height, Component displayString, Button.OnPress onPress) {
        this(xPos, yPos, width, height, () -> displayString, RenderPlace.CENTRED, onPress);
    }

    public boolean mouseClicked(double d, double e, int i) {
        if (this.hasText()) {
            return super.mouseClicked(d, e, i);
        }
        return false;
    }

    public void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partial) {
        this.visible = this.hasText();
        if (this.visible) {
            this.isHovered = mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.width && mouseY < this.getY() + this.height;
            Component buttonText = this.displayGetter.get();
            if (this.renderPlace == RenderPlace.CENTRED) {
                guiGraphics.drawCenteredString(Minecraft.getInstance().font, buttonText, this.getX() + this.width / 2, this.getY() + (this.height - 8) / 2, 0xFFFFFF);
            } else {
                guiGraphics.drawString(Minecraft.getInstance().font, buttonText, this.getX(), this.getY(), 0xFFFFFF);
            }
        }
    }

    public boolean hasText() {
        return !this.displayGetter.get().toString().isEmpty();
    }

    public static enum RenderPlace {
        EXACT,
        CENTRED;

    }
}

