/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.sentry;

import dev.architectury.platform.Platform;
import net.creeperhost.polylib.io.sentry.Sentry;
import net.creeperhost.polylib.io.sentry.SentryOptions;
import net.creeperhost.polylib.io.sentry.protocol.SentryException;
import net.neoforged.api.distmarker.Dist;

public class SentryRegistry {
    public static Sentry.OptionsConfiguration<SentryOptions> registerSentryHandler(String dsn, String packagePath) {
        return options -> {
            options.setDsn(dsn);
            options.setTracesSampleRate(Platform.isDevelopmentEnvironment() ? 1.0 : 0.025);
            options.setEnvironment(Platform.getMinecraftVersion());
            options.setTag("modloader", Platform.isMinecraftForge() ? "Forge" : "Fabric");
            options.setTag("ram", String.valueOf(Runtime.getRuntime().maxMemory() / 1024L / 1024L));
            options.setDist(System.getProperty("os.arch"));
            options.setServerName(Platform.getEnv() == Dist.CLIENT ? "integrated" : "dedicated");
            options.setDebug(Platform.isDevelopmentEnvironment());
            options.addInAppInclude(packagePath);
        };
    }

    public static void registerSentryHandler(String dsn, String release, String packagePath) {
        Sentry.init(options -> {
            options.setDsn(dsn);
            options.setTracesSampleRate(Platform.isDevelopmentEnvironment() ? 1.0 : 0.025);
            options.setRelease(release);
            options.setEnvironment(Platform.getMinecraftVersion());
            options.setTag("modloader", Platform.isMinecraftForge() ? "Forge" : "Fabric");
            options.setTag("ram", String.valueOf(Runtime.getRuntime().maxMemory() / 1024L / 1024L));
            options.setDist(System.getProperty("os.arch"));
            options.setServerName(Platform.getEnv() == Dist.CLIENT ? "integrated" : "dedicated");
            options.setDebug(Platform.isDevelopmentEnvironment());
            options.addInAppInclude(packagePath);
            options.setBeforeSend((event, hint) -> {
                if (event.getExceptions() == null) {
                    return null;
                }
                for (SentryException exception : event.getExceptions()) {
                    if (exception.getStacktrace() == null || !exception.getStacktrace().toString().contains("net.creeperhost")) continue;
                    return event;
                }
                return null;
            });
        });
    }
}

