/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.listener.listeners;

import de.keksuccino.fancymenu.customization.listener.AbstractListener;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import java.util.List;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OnServerLeftListener
extends AbstractListener {
    @Nullable
    private String lastServerIp;

    public OnServerLeftListener() {
        super("server_left");
    }

    public void onServerLeft(@Nullable String serverIp) {
        this.lastServerIp = serverIp;
        this.notifyAllInstances();
    }

    @Override
    protected void buildCustomVariablesAndAddToList(List<AbstractListener.CustomVariable> list) {
        list.add(new AbstractListener.CustomVariable("server_ip", () -> this.formatServerIp(this.lastServerIp)));
    }

    private String formatServerIp(@Nullable String value) {
        if (value == null || value.isBlank()) {
            return "ERROR";
        }
        return value;
    }

    @Override
    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"fancymenu.listeners.on_server_left");
    }

    @Override
    @NotNull
    public List<Component> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedLines("fancymenu.listeners.on_server_left.desc", new String[0]));
    }
}

