/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.simpletomb.particle;

import com.lothrazar.simpletomb.particle.TransparentParticle;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.SimpleParticleType;

public class ParticleRotatingSmoke
extends TransparentParticle {
    private final SpriteSet spriteSet;
    private final float rotIncrement;

    private ParticleRotatingSmoke(SpriteSet spriteSet, ClientLevel level, double x, double y, double z) {
        super(level, x, y + 0.3, z);
        this.zd = 0.0;
        this.yd = 0.0;
        this.xd = 0.0;
        this.setAlpha(0.5f);
        this.scale(2.0f);
        this.setLifetime(100);
        this.hasPhysics = false;
        this.oRoll = this.roll = (float)((double)level.random.nextFloat() * Math.PI * 2.0);
        this.rotIncrement = 0.06283185f;
        this.setColor(0.7f, 0.7f, 0.7f);
        this.spriteSet = spriteSet;
        this.setSpriteFromAge(this.spriteSet);
    }

    private void updatePosition() {
        this.oRoll = this.roll;
        this.roll += this.rotIncrement;
        float color = 0.6f + this.level.random.nextFloat() * 0.2f;
        this.setColor(color, color, color);
    }

    public void tick() {
        super.tick();
        if (this.isAlive()) {
            this.updatePosition();
            this.setSpriteFromAge(this.spriteSet);
        }
    }

    protected int getLightColor(float partialTick) {
        int skylight = 15;
        int blocklight = 15;
        return skylight << 20 | blocklight << 4;
    }

    @Override
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double motionX, double motionY, double motionZ) {
            return new ParticleRotatingSmoke(this.spriteSet, level, x, y, z);
        }
    }
}

