/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.structures_tweaker.config.core;

import com.leclowndu93150.structures_tweaker.config.core.GlobalStructureConfig;
import com.leclowndu93150.structures_tweaker.config.core.StructureConfig;
import com.leclowndu93150.structures_tweaker.config.properties.ConfigProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InheritedStructureConfig
extends StructureConfig {
    private final GlobalStructureConfig globalConfig;
    private final Map<String, Object> individualOverrides;

    public InheritedStructureConfig(GlobalStructureConfig globalConfig, Map<String, Object> individualOverrides) {
        this.globalConfig = globalConfig;
        this.individualOverrides = new HashMap<String, Object>(individualOverrides);
        HashMap<String, Object> merged = new HashMap<String, Object>();
        merged.putAll(globalConfig.getAllValues());
        for (Map.Entry<String, Object> entry : individualOverrides.entrySet()) {
            Object globalValue = merged.get(entry.getKey());
            Object individualValue = entry.getValue();
            if (globalValue instanceof List && individualValue instanceof List) {
                ArrayList mergedList = new ArrayList();
                mergedList.addAll((List)globalValue);
                mergedList.addAll((List)individualValue);
                merged.put(entry.getKey(), mergedList);
                continue;
            }
            merged.put(entry.getKey(), individualValue);
        }
        for (Map.Entry<String, Object> entry : merged.entrySet()) {
            this.setValue(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public <T> T getValue(ConfigProperty<T> property) {
        Object globalValue = this.globalConfig.getRawValue(property.getKey());
        Object individualValue = this.individualOverrides.get(property.getKey());
        if (globalValue instanceof List && individualValue instanceof List) {
            ArrayList mergedList = new ArrayList();
            mergedList.addAll((List)globalValue);
            mergedList.addAll((List)individualValue);
            return property.convert(mergedList);
        }
        if (this.individualOverrides.containsKey(property.getKey())) {
            return property.convert(individualValue);
        }
        return this.globalConfig.getValue(property);
    }

    public boolean isOverridden(ConfigProperty<?> property) {
        return this.individualOverrides.containsKey(property.getKey());
    }

    public Map<String, Object> getIndividualOverrides() {
        return new HashMap<String, Object>(this.individualOverrides);
    }

    public GlobalStructureConfig getGlobalConfig() {
        return this.globalConfig;
    }
}

