/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.structures_tweaker.config.core;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.leclowndu93150.structures_tweaker.config.properties.ConfigProperty;
import com.leclowndu93150.structures_tweaker.config.properties.ConfigRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ModularStructureConfig {
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private final Map<String, Object> explicitlySetValues = new HashMap<String, Object>();

    public ModularStructureConfig() {
        for (ConfigProperty<?> property : ConfigRegistry.getAllProperties().values()) {
            this.properties.put(property.getKey(), property.getDefaultValue());
        }
    }

    public ModularStructureConfig(Map<String, Object> initialValues) {
        this();
        this.properties.putAll(initialValues);
        this.explicitlySetValues.putAll(initialValues);
    }

    public <T> T getValue(ConfigProperty<T> property) {
        Object value = this.properties.get(property.getKey());
        if (value == null) {
            return property.getDefaultValue();
        }
        return property.convert(value);
    }

    public Object getRawValue(String key) {
        return this.properties.get(key);
    }

    public <T> void setValue(ConfigProperty<T> property, T value) {
        this.properties.put(property.getKey(), value);
        this.explicitlySetValues.put(property.getKey(), value);
    }

    public void setValue(String key, Object value) {
        this.properties.put(key, value);
        this.explicitlySetValues.put(key, value);
    }

    public Map<String, Object> getAllValues() {
        return new HashMap<String, Object>(this.properties);
    }

    public Map<String, Object> getExplicitlySetValues() {
        return new HashMap<String, Object>(this.explicitlySetValues);
    }

    public void applyMissingDefaults() {
        for (ConfigProperty<?> property : ConfigRegistry.getAllProperties().values()) {
            if (this.properties.containsKey(property.getKey())) continue;
            this.properties.put(property.getKey(), property.getDefaultValue());
        }
    }

    public static ModularStructureConfig fromJson(JsonObject json) {
        return ModularStructureConfig.fromJson(json, true);
    }

    public static ModularStructureConfig fromJson(JsonObject json, boolean applyDefaults) {
        ModularStructureConfig config = new ModularStructureConfig();
        for (Map.Entry entry : json.entrySet()) {
            String key = (String)entry.getKey();
            JsonElement value = (JsonElement)entry.getValue();
            ConfigProperty<?> property = ConfigRegistry.getProperty(key);
            if (property == null) continue;
            if (property.getType() == Boolean.class && value.isJsonPrimitive()) {
                config.setValue(key, (Object)value.getAsBoolean());
                continue;
            }
            if (property.getType() == Integer.class && value.isJsonPrimitive()) {
                config.setValue(key, (Object)value.getAsInt());
                continue;
            }
            if (property.getType() == String.class && value.isJsonPrimitive()) {
                config.setValue(key, value.getAsString());
                continue;
            }
            if (property.getType() != List.class || !value.isJsonArray()) continue;
            ArrayList<String> list = new ArrayList<String>();
            JsonArray array = value.getAsJsonArray();
            for (JsonElement element : array) {
                if (!element.isJsonPrimitive()) continue;
                list.add(element.getAsString());
            }
            config.setValue(key, list);
        }
        if (applyDefaults) {
            config.applyMissingDefaults();
        }
        return config;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        for (ConfigProperty<?> property : ConfigRegistry.getAllProperties().values()) {
            String key = property.getKey();
            Object value = this.properties.get(key);
            if (value == null) continue;
            if (value instanceof Boolean) {
                json.addProperty(key, (Boolean)value);
                continue;
            }
            if (value instanceof Number) {
                json.addProperty(key, (Number)value);
                continue;
            }
            if (value instanceof String) {
                json.addProperty(key, (String)value);
                continue;
            }
            if (!(value instanceof List)) continue;
            JsonArray array = new JsonArray();
            for (Object item : (List)value) {
                if (item == null) continue;
                array.add(item.toString());
            }
            json.add(key, (JsonElement)array);
        }
        return json;
    }

    public boolean canBreakBlocks() {
        return this.getValue(ConfigRegistry.CAN_BREAK_BLOCKS);
    }

    public boolean canInteract() {
        return this.getValue(ConfigRegistry.CAN_INTERACT);
    }

    public boolean canPlaceBlocks() {
        return this.getValue(ConfigRegistry.CAN_PLACE_BLOCKS);
    }

    public boolean allowPlayerPVP() {
        return this.getValue(ConfigRegistry.ALLOW_PLAYER_PVP);
    }

    public boolean allowCreatureSpawning() {
        return this.getValue(ConfigRegistry.ALLOW_CREATURE_SPAWNING);
    }

    public boolean allowFireSpread() {
        return this.getValue(ConfigRegistry.ALLOW_FIRE_SPREAD);
    }

    public boolean allowExplosions() {
        return this.getValue(ConfigRegistry.ALLOW_EXPLOSIONS);
    }

    public boolean allowItemPickup() {
        return this.getValue(ConfigRegistry.ALLOW_ITEM_PICKUP);
    }

    public boolean onlyProtectOriginalBlocks() {
        return this.getValue(ConfigRegistry.ONLY_PROTECT_ORIGINAL_BLOCKS);
    }

    public boolean allowElytraFlight() {
        return this.getValue(ConfigRegistry.ALLOW_ELYTRA_FLIGHT);
    }

    public boolean allowEnderPearls() {
        return this.getValue(ConfigRegistry.ALLOW_ENDER_PEARLS);
    }

    public boolean allowRiptide() {
        return this.getValue(ConfigRegistry.ALLOW_RIPTIDE);
    }

    public boolean allowCreativeFlight() {
        return this.getValue(ConfigRegistry.ALLOW_CREATIVE_FLIGHT);
    }
}

