/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.reliquified_twilight_forest.handler;

import it.hurts.octostudios.reliquified_twilight_forest.item.BundleLike;
import it.hurts.sskirillss.relics.api.events.common.ContainerSlotClickEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;

@EventBusSubscriber
public class BundleLikeEventHandler {
    @SubscribeEvent
    public static void onSlotClick(ContainerSlotClickEvent event) {
        if (event.getAction() != ClickAction.SECONDARY) {
            return;
        }
        ItemStack slotStack = event.getSlotStack();
        ItemStack heldStack = event.getHeldStack();
        Player player = event.getEntity();
        Item item = slotStack.getItem();
        if (item instanceof BundleLike) {
            BundleLike relicInSlot = (BundleLike)item;
            BundleLikeEventHandler.handleRelicInteraction(event, player, relicInSlot, slotStack, heldStack, true);
        } else {
            item = heldStack.getItem();
            if (item instanceof BundleLike) {
                BundleLike relicInHeld = (BundleLike)item;
                BundleLikeEventHandler.handleRelicInteraction(event, player, relicInHeld, heldStack, slotStack, false);
            }
        }
    }

    private static void handleRelicInteraction(ContainerSlotClickEvent event, Player player, BundleLike relic, ItemStack primaryStack, ItemStack secondaryStack, boolean primaryIsSlot) {
        if (relic.isAcceptable(secondaryStack)) {
            if (relic.tryInsert(player, primaryStack, secondaryStack)) {
                relic.playInsertSound(player, secondaryStack);
            }
            event.setCanceled(true);
        } else if (secondaryStack.isEmpty()) {
            event.setCanceled(true);
            ItemStack poppedItem = relic.pop(player, primaryStack);
            if (!poppedItem.isEmpty()) {
                relic.playPopSound(player, poppedItem);
                if (primaryIsSlot) {
                    player.containerMenu.setCarried(poppedItem);
                } else {
                    event.getSlot().set(poppedItem);
                }
            }
        }
    }
}

