/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.reliquified_twilight_forest.mixin;

import it.hurts.octostudios.reliquified_twilight_forest.item.relic.SteelCapeItem;
import it.hurts.sskirillss.relics.init.EffectRegistry;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import twilightforest.entity.projectile.ChainBlock;
import twilightforest.init.TFSounds;

@Mixin(value={ChainBlock.class})
public abstract class ChainBlockMixin {
    @Shadow
    @Nullable
    private ItemStack stack;

    @Redirect(method={"onHitEntity"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"))
    public boolean redirected(Entity instance, DamageSource source, float amount) {
        Item item;
        if (this.stack == null || !((item = this.stack.getItem()) instanceof SteelCapeItem)) {
            return instance.hurt(source, amount);
        }
        SteelCapeItem relic = (SteelCapeItem)item;
        ChainBlock self = (ChainBlock)this;
        if (instance.hurt(source, (float)relic.getStatValue(this.stack, "iron_guard", "damage"))) {
            self.playSound((SoundEvent)TFSounds.BLOCK_AND_CHAIN_HIT.get(), 1.0f, self.getRandom().nextFloat());
            if (instance instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)instance;
                living.addEffect(new MobEffectInstance((Holder)EffectRegistry.STUN, (int)relic.getStatValue(this.stack, "iron_guard", "stun_duration"), 0, false, true, true));
            }
            return false;
        }
        return instance.hurt(source, amount);
    }
}

