/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.reliquified_twilight_forest.network;

import it.hurts.octostudios.reliquified_twilight_forest.init.ItemRegistry;
import it.hurts.octostudios.reliquified_twilight_forest.item.relic.ScaledCloakItem;
import it.hurts.sskirillss.relics.init.DataComponentRegistry;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import java.util.function.Supplier;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ScaledCloakWallClimbPacket(boolean isColliding) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ScaledCloakWallClimbPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"reliquified_twilight_forest", (String)"scaled_cloak_wall_climb"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ScaledCloakWallClimbPacket> STREAM_CODEC = CustomPacketPayload.codec(ScaledCloakWallClimbPacket::write, ScaledCloakWallClimbPacket::new);

    public ScaledCloakWallClimbPacket(RegistryFriendlyByteBuf buf) {
        this(buf.readBoolean());
    }

    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeBoolean(this.isColliding);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(ScaledCloakWallClimbPacket packet, IPayloadContext ctx) {
        if (ctx.flow().isClientbound()) {
            return;
        }
        ctx.enqueueWork(() -> {
            Player player = ctx.player();
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ItemRegistry.SCALED_CLOAK.get()));
            int time = (Integer)stack.getOrDefault((Supplier)DataComponentRegistry.TIME, (Object)0);
            Item patt0$temp = stack.getItem();
            if (!(patt0$temp instanceof ScaledCloakItem)) {
                return;
            }
            ScaledCloakItem relic = (ScaledCloakItem)patt0$temp;
            int maxTime = (int)Math.round(relic.getStatValue(stack, "wall_crawler", "max_time"));
            if (packet.isColliding()) {
                player.fallDistance = 0.0f;
                if (time > 0) {
                    stack.set((Supplier)DataComponentRegistry.TIME, (Object)(--time));
                }
                if (player.tickCount % 20 == 0) {
                    relic.spreadRelicExperience((LivingEntity)player, stack, 1);
                }
            }
            if (player.onGround() && time != maxTime) {
                stack.set((Supplier)DataComponentRegistry.TIME, (Object)maxTime);
            }
        });
    }
}

