/*
 * Decompiled with CFR 0.152.
 */
package me.axieum.mcmod.authme.api.gui.screen;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import me.axieum.mcmod.authme.api.AuthMe;
import me.axieum.mcmod.authme.api.gui.screen.AuthScreen;
import me.axieum.mcmod.authme.api.util.MicrosoftUtils;
import me.axieum.mcmod.authme.api.util.SessionUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.apache.http.conn.ConnectTimeoutException;

public class MicrosoftAuthScreen
extends AuthScreen {
    private ExecutorService executor = null;
    private CompletableFuture<Void> task = null;
    private StringWidget statusWidget = null;
    private final boolean selectAccount;

    public MicrosoftAuthScreen(Screen parentScreen, Screen successScreen, boolean selectAccount) {
        super((Component)Component.translatable((String)"gui.authme.microsoft.title"), parentScreen, successScreen);
        this.selectAccount = selectAccount;
        this.closeOnSuccess = true;
    }

    @Override
    protected void init() {
        super.init();
        assert (this.minecraft != null);
        StringWidget titleWidget = new StringWidget(this.width, this.height, this.title, this.font);
        titleWidget.setColor(0xFFFFFF);
        titleWidget.setPosition(this.width / 2 - titleWidget.getWidth() / 2, this.height / 2 - titleWidget.getHeight() / 2 - 27);
        this.addRenderableWidget((GuiEventListener)titleWidget);
        this.statusWidget = new StringWidget(this.width, this.height, this.title, this.font);
        this.statusWidget.setColor(0xDDDDDD);
        this.statusWidget.setPosition(this.width / 2 - this.statusWidget.getWidth() / 2, this.height / 2 - this.statusWidget.getHeight() / 2 - 1);
        this.addRenderableWidget((GuiEventListener)this.statusWidget);
        Button cancelBtn = Button.builder((Component)Component.translatable((String)"gui.cancel"), button -> this.onClose()).bounds(this.width / 2 - 50, this.height / 2 + 22, 100, 20).build();
        this.addRenderableWidget((GuiEventListener)cancelBtn);
        if (this.task != null) {
            return;
        }
        this.statusWidget.setMessage((Component)Component.translatable((String)"gui.authme.microsoft.status.checkBrowser"));
        this.executor = Executors.newSingleThreadExecutor();
        this.task = ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)MicrosoftUtils.acquireMSAuthCode(success -> Component.translatable((String)"gui.authme.microsoft.browser").getString(), this.executor, this.selectAccount ? MicrosoftUtils.MicrosoftPrompt.SELECT_ACCOUNT : null).thenComposeAsync(msAuthCode -> {
            this.statusWidget.setMessage((Component)Component.translatable((String)"gui.authme.microsoft.status.msAccessToken"));
            return MicrosoftUtils.acquireMSAccessToken(msAuthCode, this.executor);
        })).thenComposeAsync(msAccessToken -> {
            this.statusWidget.setMessage((Component)Component.translatable((String)"gui.authme.microsoft.status.xboxAccessToken"));
            return MicrosoftUtils.acquireXboxAccessToken(msAccessToken, this.executor);
        })).thenComposeAsync(xboxAccessToken -> {
            this.statusWidget.setMessage((Component)Component.translatable((String)"gui.authme.microsoft.status.xboxXstsToken"));
            return MicrosoftUtils.acquireXboxXstsToken(xboxAccessToken, this.executor);
        })).thenComposeAsync(xboxXstsData -> {
            this.statusWidget.setMessage((Component)Component.translatable((String)"gui.authme.microsoft.status.mcAccessToken"));
            return MicrosoftUtils.acquireMCAccessToken((String)xboxXstsData.get("Token"), (String)xboxXstsData.get("uhs"), this.executor);
        })).thenComposeAsync(mcToken -> {
            this.statusWidget.setMessage((Component)Component.translatable((String)"gui.authme.microsoft.status.mcProfile"));
            return MicrosoftUtils.login(mcToken, this.executor);
        })).thenAccept(user -> {
            SessionUtils.setUser(user);
            SystemToast.add((ToastComponent)this.minecraft.getToasts(), (SystemToast.SystemToastId)SystemToast.SystemToastId.PERIODIC_NOTIFICATION, (Component)Component.translatable((String)"gui.authme.toast.greeting", (Object[])new Object[]{Component.literal((String)user.getName())}), null);
            AuthMe.LOGGER.info("Successfully logged in via Microsoft!");
            this.success = true;
        })).exceptionally(error -> {
            String key = error.getCause() instanceof ConnectTimeoutException ? "gui.authme.error.timeout" : ("NOT_FOUND: Not Found".equals(error.getCause().getMessage()) ? "gui.authme.error.notPurchased" : "gui.authme.error.generic");
            this.statusWidget.setMessage((Component)Component.translatable((String)key).withStyle(ChatFormatting.RED));
            cancelBtn.setMessage((Component)Component.translatable((String)"gui.back"));
            return null;
        });
    }

    @Override
    public void onClose() {
        if (this.task != null && !this.task.isDone()) {
            this.task.cancel(true);
            this.executor.shutdownNow();
        }
        super.onClose();
    }
}

