/*
 * Decompiled with CFR 0.152.
 */
package me.axieum.mcmod.authme.mixin;

import me.axieum.mcmod.authme.api.AuthMe;
import me.axieum.mcmod.authme.api.gui.screen.AuthMethodScreen;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.DisconnectedScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.DisconnectionDetails;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={DisconnectedScreen.class})
public abstract class DisconnectedScreenMixin
extends Screen {
    @Shadow
    @Final
    private Screen parent;
    @Shadow
    @Final
    private DisconnectionDetails details;

    private DisconnectedScreenMixin(Component title) {
        super(title);
    }

    @Inject(method={"init()V"}, at={@At(value="TAIL")})
    private void init(CallbackInfo ci) {
        if (DisconnectedScreenMixin.authme$isUserRelated(this.details.reason())) {
            AuthMe.LOGGER.info("Adding auth button to the disconnected screen");
            assert (this.minecraft != null);
            Button backButton = (Button)this.children().get(2);
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.authme.button.relogin"), btn -> this.minecraft.setScreen((Screen)new AuthMethodScreen(this.parent))).bounds(backButton.getX(), backButton.getY(), backButton.getWidth(), backButton.getHeight()).build());
            backButton.setY(backButton.getY() + backButton.getHeight() + 4);
        }
    }

    @Unique
    private static boolean authme$isUserRelated(@Nullable Component reason) {
        ComponentContents componentContents;
        if (reason != null && (componentContents = reason.getContents()) instanceof TranslatableContents) {
            String key;
            TranslatableContents content = (TranslatableContents)componentContents;
            return switch (key = content.getKey()) {
                case "disconnect.kicked", "multiplayer.disconnect.banned", "multiplayer.disconnect.banned.reason", "multiplayer.disconnect.banned.expiration", "multiplayer.disconnect.duplicate_login", "multiplayer.disconnect.kicked", "multiplayer.disconnect.unverified_username", "multiplayer.disconnect.not_whitelisted", "multiplayer.disconnect.name_taken", "multiplayer.disconnect.missing_public_key", "multiplayer.disconnect.expired_public_key", "multiplayer.disconnect.invalid_public_key_signature", "multiplayer.disconnect.unsigned_chat", "multiplayer.disconnect.chat_validation_failed" -> true;
                default -> key.startsWith("disconnect.loginFailed");
            };
        }
        return false;
    }
}

