/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsjewelry.compat.jei;

import io.redspace.ironsjewelry.IronsJewelry;
import io.redspace.ironsjewelry.block.jewelcrafting_station.JewelcraftingStationScreen;
import io.redspace.ironsjewelry.compat.jei.AdvancedPatternJeiHandler;
import io.redspace.ironsjewelry.compat.jei.JewelcraftingJeiGuiHandler;
import io.redspace.ironsjewelry.compat.jei.JewelcraftingJeiRecipeCategory;
import io.redspace.ironsjewelry.core.data.JewelryData;
import io.redspace.ironsjewelry.core.data.MaterialDefinition;
import io.redspace.ironsjewelry.core.data.PatternDefinition;
import io.redspace.ironsjewelry.registry.BlockRegistry;
import io.redspace.ironsjewelry.registry.ComponentRegistry;
import io.redspace.ironsjewelry.registry.IronsJewelryRegistries;
import io.redspace.ironsjewelry.registry.ItemRegistry;
import io.redspace.ironsjewelry.utils.Utils;
import java.util.ArrayList;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.advanced.ISimpleRecipeManagerPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IAdvancedRegistration;
import mezz.jei.api.registration.IExtraIngredientRegistration;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

@mezz.jei.api.JeiPlugin
public class JeiPlugin
implements IModPlugin {
    private static final ResourceLocation ID = IronsJewelry.id("jei_plugin");
    public static final ISubtypeInterpreter<ItemStack> JEWELRY_INTERPRETER = new ISubtypeInterpreter<ItemStack>(){

        @Nullable
        public String getSubtypeData(ItemStack ingredient, UidContext context) {
            ResourceKey pattern;
            JewelryData data = JewelryData.get(ingredient);
            if (data.isValid() && (pattern = data.pattern().getKey()) != null) {
                return pattern.location().toString();
            }
            return null;
        }

        public String getLegacyStringSubtypeInfo(ItemStack ingredient, UidContext context) {
            return this.getSubtypeData(ingredient, context);
        }
    };
    public static final ISubtypeInterpreter<ItemStack> PATTERN_INTERPRETER = new ISubtypeInterpreter<ItemStack>(){

        @Nullable
        public String getSubtypeData(ItemStack ingredient, UidContext context) {
            Holder pattern = (Holder)ingredient.get(ComponentRegistry.STORED_PATTERN);
            if (pattern != null && pattern.getKey() != null) {
                return pattern.getKey().location().toString();
            }
            return null;
        }

        public String getLegacyStringSubtypeInfo(ItemStack ingredient, UidContext context) {
            return this.getSubtypeData(ingredient, context);
        }
    };

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGenericGuiContainerHandler(JewelcraftingStationScreen.class, (IGuiContainerHandler)new JewelcraftingJeiGuiHandler());
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new JewelcraftingJeiRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(JewelcraftingJeiRecipeCategory.RECIPE_TYPE, IronsJewelryRegistries.patternRegistry(Minecraft.getInstance().level.registryAccess()).stream().toList());
    }

    public void registerExtraIngredients(IExtraIngredientRegistration registration) {
        Registry<MaterialDefinition> materialRegistry = IronsJewelryRegistries.materialRegistry(Minecraft.getInstance().level.registryAccess());
        Registry<PatternDefinition> patternRegistry = IronsJewelryRegistries.patternRegistry(Minecraft.getInstance().level.registryAccess());
        ArrayList<ItemStack> exampleJewelryItems = new ArrayList<ItemStack>();
        for (PatternDefinition pattern : patternRegistry) {
            exampleJewelryItems.add(Utils.createExampleJewelryItem(Minecraft.getInstance().level.registryAccess(), (Holder<PatternDefinition>)patternRegistry.wrapAsHolder((Object)pattern)));
        }
        registration.addExtraItemStacks(exampleJewelryItems);
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter((Item)ItemRegistry.RING.get(), JEWELRY_INTERPRETER);
        registration.registerSubtypeInterpreter((Item)ItemRegistry.NECKLACE.get(), JEWELRY_INTERPRETER);
        registration.registerSubtypeInterpreter((Item)ItemRegistry.RECIPE.get(), PATTERN_INTERPRETER);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlockRegistry.JEWELCRAFTING_STATION_BLOCK.get()), new RecipeType[]{JewelcraftingJeiRecipeCategory.RECIPE_TYPE});
    }

    public void registerAdvanced(IAdvancedRegistration registration) {
        registration.addTypedRecipeManagerPlugin(JewelcraftingJeiRecipeCategory.RECIPE_TYPE, (ISimpleRecipeManagerPlugin)new AdvancedPatternJeiHandler());
    }
}

