/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsjewelry.compat.jei;

import io.redspace.ironsjewelry.IronsJewelry;
import io.redspace.ironsjewelry.core.data.MaterialDefinition;
import io.redspace.ironsjewelry.core.data.PartDefinition;
import io.redspace.ironsjewelry.core.data.PartIngredient;
import io.redspace.ironsjewelry.core.data.PatternDefinition;
import io.redspace.ironsjewelry.registry.BlockRegistry;
import io.redspace.ironsjewelry.registry.IronsJewelryRegistries;
import io.redspace.ironsjewelry.utils.Utils;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class JewelcraftingJeiRecipeCategory
implements IRecipeCategory<PatternDefinition> {
    public static final RecipeType<PatternDefinition> RECIPE_TYPE = RecipeType.create((String)"irons_jewelry", (String)"jewelcrafting", PatternDefinition.class);
    private final IDrawable background;
    private final IDrawable icon;
    private static final int buffer = 32;
    private static final int width = 127;
    private static final int height = 60;

    public JewelcraftingJeiRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(IronsJewelry.id("textures/gui/sprites/jewelcrafting_station/jei_bg.png"), 0, 0, 127, 60).addPadding(0, 0, 32, 0).setTextureSize(127, 60).build();
        this.icon = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)BlockRegistry.JEWELCRAFTING_STATION_BLOCK.get()));
    }

    public RecipeType<PatternDefinition> getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.translatable((String)"container.irons_jewelry.jewelcrafting_station");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, PatternDefinition recipe, IFocusGroup focuses) {
        Registry<MaterialDefinition> materialRegistry = IronsJewelryRegistries.materialRegistry(Minecraft.getInstance().level.registryAccess());
        ItemStack output = Utils.createExampleJewelryItem(Minecraft.getInstance().level.registryAccess(), (Holder<PatternDefinition>)IronsJewelryRegistries.patternRegistry(Minecraft.getInstance().level.registryAccess()).wrapAsHolder((Object)recipe));
        IRecipeSlotBuilder outputSlot = ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 137, 22).addItemStacks(List.of(output))).setSlotName("output");
        int totalWidth = 95;
        int count = recipe.partTemplate().size();
        int widthPer = 20;
        int leftPos = (totalWidth - count * widthPer) / 2;
        List<PartIngredient> template = recipe.partTemplate();
        for (int i = 0; i < template.size(); ++i) {
            PartIngredient partIngredient = template.get(i);
            PartDefinition part = (PartDefinition)partIngredient.part().value();
            List<ItemStack> stacks = materialRegistry.stream().filter(material -> part.canUseMaterial(material.materialType())).map(MaterialDefinition::ingredient).filter(ingr -> !ingr.hasNoItems()).flatMap(ingredient -> Arrays.stream(ingredient.getItems())).map(ItemStack::copy).toList();
            stacks.forEach(stack -> stack.setCount(partIngredient.materialCost()));
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 32 + leftPos + i * widthPer, 20).addItemStacks(stacks)).setSlotName("input" + i);
        }
    }

    public void draw(PatternDefinition recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        int bgstart;
        super.draw((Object)recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
        MutableComponent title = Component.translatable((String)recipe.descriptionId()).withStyle(ChatFormatting.UNDERLINE);
        int width = Minecraft.getInstance().font.width((FormattedText)title);
        int x = 79 - width / 2;
        int y = 4;
        int bgend = bgstart = -1272574196;
        int borderstart = 1356909215;
        int borderend = 1352700274;
        guiGraphics.drawManaged(() -> TooltipRenderUtil.renderTooltipBackground((GuiGraphics)guiGraphics, (int)x, (int)y, (int)width, (int)9, (int)0, (int)bgstart, (int)bgend, (int)borderstart, (int)borderend));
        guiGraphics.drawString(Minecraft.getInstance().font, (Component)title, x, y, 0xFFFFFF, true);
    }
}

