/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsjewelry.core.data;

import io.redspace.ironsjewelry.IronsJewelry;
import io.redspace.ironsjewelry.core.bonuses.BonusType;
import io.redspace.ironsjewelry.core.data.CooldownInstance;
import io.redspace.ironsjewelry.core.data.PatternDefinition;
import io.redspace.ironsjewelry.network.packets.SyncPlayerDataPacket;
import io.redspace.ironsjewelry.registry.DataAttachmentRegistry;
import io.redspace.ironsjewelry.registry.IronsJewelryRegistries;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.attachment.IAttachmentSerializer;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class PlayerData {
    private final Set<Holder<PatternDefinition>> learnedPatterns = new HashSet<Holder<PatternDefinition>>();
    private final Map<ResourceLocation, CooldownInstance> cooldowns = new HashMap<ResourceLocation, CooldownInstance>();
    private int bookmarkIndex = -1;

    public int getBookmarkIndex() {
        return this.bookmarkIndex;
    }

    public boolean hasBookmark() {
        return this.bookmarkIndex >= 0;
    }

    public void removeBookmark() {
        this.bookmarkIndex = -1;
    }

    public void setBookmarkIndex(int bookmarkIndex) {
        this.bookmarkIndex = bookmarkIndex;
    }

    public Set<Holder<PatternDefinition>> getLearnedPatterns() {
        return this.learnedPatterns;
    }

    public void tickCooldowns(int actualTicks) {
        if (!this.cooldowns.isEmpty()) {
            List<Map.Entry> spells = this.cooldowns.entrySet().stream().filter(x -> this.decrementCooldown((CooldownInstance)x.getValue(), actualTicks)).toList();
            spells.forEach(spell -> this.cooldowns.remove(spell.getKey()));
        }
    }

    public boolean decrementCooldown(CooldownInstance c, int amount) {
        c.decrementBy(amount);
        return c.getRemainingTicks() <= 0;
    }

    public boolean isOnCooldown(BonusType bonusType) {
        return this.isOnCooldown(IronsJewelryRegistries.BONUS_TYPE_REGISTRY.getKey((Object)bonusType));
    }

    public boolean isOnCooldown(ResourceLocation resourceLocation) {
        return this.cooldowns.containsKey(resourceLocation) && this.cooldowns.get((Object)resourceLocation).firstTick;
    }

    public void addCooldown(BonusType bonusType, int ticks) {
        ResourceLocation k = IronsJewelryRegistries.BONUS_TYPE_REGISTRY.getKey((Object)bonusType);
        CooldownInstance cooldown = this.cooldowns.get(k);
        if (cooldown != null && cooldown.remainingTicks >= ticks) {
            return;
        }
        this.cooldowns.put(k, new CooldownInstance(ticks));
    }

    public boolean learn(Holder<PatternDefinition> patternDefinition) {
        return this.learnedPatterns.add(patternDefinition);
    }

    public boolean learnAndSync(ServerPlayer serverPlayer, Holder<PatternDefinition> patternDefinition) {
        if (this.learnedPatterns.add(patternDefinition)) {
            this.sync(serverPlayer);
            return true;
        }
        return false;
    }

    public void sync(ServerPlayer serverPlayer) {
        PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SyncPlayerDataPacket(this), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public boolean isLearned(Holder<PatternDefinition> definition) {
        return this.learnedPatterns.contains(definition);
    }

    public void clear() {
        this.learnedPatterns.clear();
    }

    public static PlayerData get(Player player) {
        return (PlayerData)player.getData(DataAttachmentRegistry.PLAYER_DATA);
    }

    public static class Serializer
    implements IAttachmentSerializer<CompoundTag, PlayerData> {
        private static final String LEARNED_PATTERNS = "learned_patterns";
        private static final String COOLDOWNS = "cooldowns";

        public PlayerData read(IAttachmentHolder holder, CompoundTag compoundTag, HolderLookup.Provider provider) {
            PlayerData data = new PlayerData();
            ListTag learnedPatterns = compoundTag.getList(LEARNED_PATTERNS, 8);
            HolderGetter holderGetter = provider.asGetterLookup().lookupOrThrow(IronsJewelryRegistries.Keys.PATTERN_REGISTRY_KEY);
            for (Tag stringTag : learnedPatterns) {
                try {
                    String string = stringTag.getAsString();
                    Optional pattern = holderGetter.get(ResourceKey.create(IronsJewelryRegistries.Keys.PATTERN_REGISTRY_KEY, (ResourceLocation)ResourceLocation.parse((String)string)));
                    pattern.ifPresent(data.learnedPatterns::add);
                }
                catch (Exception e) {}
            }
            ListTag cooldowns = compoundTag.getList(COOLDOWNS, 10);
            for (Tag tag : cooldowns) {
                try {
                    CompoundTag cooldown = (CompoundTag)tag;
                    ResourceLocation id = ResourceLocation.parse((String)cooldown.getString("id"));
                    int rt = cooldown.getInt("rt");
                    int tt = cooldown.getInt("tt");
                    data.cooldowns.put(id, new CooldownInstance(rt, tt));
                }
                catch (Exception e) {}
            }
            if (compoundTag.contains("bookmark")) {
                data.bookmarkIndex = compoundTag.getInt("bookmark");
            }
            return data;
        }

        @Nullable
        public CompoundTag write(PlayerData attachment, HolderLookup.Provider provider) {
            CompoundTag tag = new CompoundTag();
            ListTag patterns = new ListTag();
            attachment.learnedPatterns.forEach(patternDefinition -> patterns.add((Object)StringTag.valueOf((String)patternDefinition.getKey().location().toString())));
            tag.put(LEARNED_PATTERNS, (Tag)patterns);
            ListTag cooldowns = new ListTag();
            attachment.cooldowns.forEach((r, cd) -> {
                CompoundTag c = new CompoundTag();
                c.put("id", (Tag)StringTag.valueOf((String)r.toString()));
                c.put("rt", (Tag)IntTag.valueOf((int)cd.remainingTicks));
                c.put("tt", (Tag)IntTag.valueOf((int)cd.totalTicks));
                cooldowns.add((Object)c);
            });
            tag.put(COOLDOWNS, (Tag)cooldowns);
            if (attachment.hasBookmark()) {
                tag.putInt("bookmark", attachment.getBookmarkIndex());
            }
            return tag;
        }

        public static void networkWrite(RegistryFriendlyByteBuf buf, PlayerData playerData) {
            buf.writeInt(playerData.learnedPatterns.size());
            for (Holder<PatternDefinition> pattern : playerData.learnedPatterns) {
                try {
                    buf.writeResourceLocation(Objects.requireNonNull(pattern.getKey()).location());
                }
                catch (Exception e) {
                    buf.writeResourceLocation(IronsJewelry.id("empty"));
                }
            }
            buf.writeInt(playerData.getBookmarkIndex());
        }

        public static PlayerData networkRead(RegistryFriendlyByteBuf buf) {
            PlayerData playerData = new PlayerData();
            int i = buf.readInt();
            Registry<PatternDefinition> registry = IronsJewelryRegistries.patternRegistry(buf.registryAccess());
            for (int j = 0; j < i; ++j) {
                try {
                    playerData.learnedPatterns.add((Holder<PatternDefinition>)registry.wrapAsHolder((Object)Objects.requireNonNull((PatternDefinition)registry.get(buf.readResourceLocation()))));
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            playerData.setBookmarkIndex(buf.readInt());
            return playerData;
        }
    }
}

