/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsjewelry.item.book;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.redspace.ironsjewelry.IronsJewelry;
import io.redspace.ironsjewelry.client.JewelryAssetHandler;
import io.redspace.ironsjewelry.core.bonuses.BonusType;
import io.redspace.ironsjewelry.core.data.Bonus;
import io.redspace.ironsjewelry.core.data.JewelryData;
import io.redspace.ironsjewelry.core.data.MaterialDefinition;
import io.redspace.ironsjewelry.core.data.PartDefinition;
import io.redspace.ironsjewelry.core.data.PartIngredient;
import io.redspace.ironsjewelry.core.data.PatternDefinition;
import io.redspace.ironsjewelry.core.data.PlayerData;
import io.redspace.ironsjewelry.core.parameters.IBonusParameterType;
import io.redspace.ironsjewelry.item.PatternRecipeItem;
import io.redspace.ironsjewelry.item.book.CyclicItemRenderer;
import io.redspace.ironsjewelry.item.book.GuideBookState;
import io.redspace.ironsjewelry.item.book.buttons.GuideBookButton;
import io.redspace.ironsjewelry.item.book.buttons.PageButton;
import io.redspace.ironsjewelry.item.book.buttons.TextButton;
import io.redspace.ironsjewelry.network.packets.ServerboundSetBookmarkPacket;
import io.redspace.ironsjewelry.registry.AssetHandlerRegistry;
import io.redspace.ironsjewelry.registry.IronsJewelryRegistries;
import io.redspace.ironsjewelry.registry.ItemRegistry;
import io.redspace.ironsjewelry.registry.ParameterTypeRegistry;
import io.redspace.ironsjewelry.utils.Utils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenAxis;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.atlas.SpriteSource;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class GuideBookScreen
extends Screen {
    public static final ResourceLocation BOOK_LOCATION = IronsJewelry.id("textures/gui/jewelcrafting_guide.png");
    private PageButton forwardButton;
    private PageButton backButton;
    private PageButton homeButton;
    private BookmarkButton bookmarkButton;
    private final List<GuideBookButton> nativeButtons = new ArrayList<GuideBookButton>();
    static final int IMAGE_WIDTH = 267;
    static final int IMAGE_HEIGHT = 210;
    static final int XM = 15;
    static final int YM = 15;
    protected int leftPos;
    protected int topPos;
    float itemScale = 2.0f;
    float titleScale = 2.0f;
    GuideBookState bookState = this.createGuidebookState();
    int lastPageNumber;
    Page cachedPage;

    public GuideBookScreen() {
        super((Component)Component.empty());
        this.minecraft = Minecraft.getInstance();
        this.font = this.minecraft.font;
        this.initPageButtons();
    }

    private void initPageButtons() {
        this.nativeButtons.clear();
        int travWidth = 23;
        int travHeight = 13;
        this.forwardButton = new PageButton(257 - travWidth, 197 - travHeight, travWidth, travHeight, IronsJewelry.id("guidebook/page_forward"), IronsJewelry.id("guidebook/page_forward_highlighted"), GuideBookState::incrementPage);
        this.backButton = new PageButton(257 - travWidth - travWidth - 2, 197 - travHeight, travWidth, travHeight, IronsJewelry.id("guidebook/page_backward"), IronsJewelry.id("guidebook/page_backward_highlighted"), GuideBookState::decrementPage);
        this.homeButton = new PageButton(257 - travWidth - travWidth - travWidth - 8 - 2, 197 - travHeight, travWidth, travHeight, IronsJewelry.id("guidebook/page_return"), IronsJewelry.id("guidebook/page_return_highlighted"), GuideBookState::returnSection);
        this.bookmarkButton = new BookmarkButton(-10, 15, 9, 48, IronsJewelry.id("guidebook/bookmark"), IronsJewelry.id("guidebook/bookmark_active"));
        this.nativeButtons.add(this.forwardButton);
        this.nativeButtons.add(this.backButton);
        this.nativeButtons.add(this.homeButton);
        this.nativeButtons.add(this.bookmarkButton);
    }

    protected void init() {
        this.leftPos = (this.width - 267) / 2;
        this.topPos = (this.height - 210) / 2;
        this.lastPageNumber = -1;
        if (this.cachedPage == null) {
            PlayerData playerdata = PlayerData.get((Player)this.minecraft.player);
            try {
                if (playerdata.hasBookmark()) {
                    this.bookState.navigateToPage(this.bookState.getGlobalPage(playerdata.getBookmarkIndex()));
                }
            }
            catch (Exception e) {
                this.setBookmark(-1);
            }
        }
    }

    public void setBookmark(int index) {
        PlayerData.get((Player)this.minecraft.player).setBookmarkIndex(index);
        PacketDistributor.sendToServer((CustomPacketPayload)new ServerboundSetBookmarkPacket(index), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    protected void chooseMaterial(Holder<MaterialDefinition> materialDefinitionHolder) {
        this.cachedPage = new MaterialPage(materialDefinitionHolder);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.blit(BOOK_LOCATION, this.leftPos, this.topPos, 0.0f, 0.0f, 267, 210, 512, 256);
    }

    private int getMaxTitleWidth() {
        int averageCharSize = 5;
        int maxCharCount = 16;
        return averageCharSize * maxCharCount;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        int currentPageNumber = this.bookState.getGlobalPageNumber();
        if (this.lastPageNumber != currentPageNumber) {
            this.lastPageNumber = currentPageNumber;
            this.cachedPage = this.bookState.getCurrentPage();
        }
        int titleX = this.leftPos + 15 - 2;
        int titleBottomY = this.topPos + 7 + (int)(16.0f * this.itemScale);
        this.cachedPage.render(guiGraphics, titleX, titleBottomY, mouseX, mouseY, partialTick);
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)this.leftPos, (float)this.topPos, 0.0f);
        for (GuideBookButton guideBookButton : this.nativeButtons) {
            guideBookButton.render(guiGraphics, guideBookButton.boundingBox(this.leftPos, this.topPos).containsPoint(mouseX, mouseY), partialTick);
        }
        for (GuideBookButton guideBookButton : this.cachedPage.extraButtons()) {
            guideBookButton.render(guiGraphics, guideBookButton.boundingBox(this.leftPos, this.topPos).containsPoint(mouseX, mouseY), partialTick);
        }
        guiGraphics.pose().popPose();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseAction) {
        for (GuideBookButton guideBookButton : this.nativeButtons) {
            int prevPage = this.bookState.getGlobalPageNumber() - 1;
            if (!guideBookButton.boundingBox(this.leftPos, this.topPos).containsPoint((int)mouseX, (int)mouseY) || !guideBookButton.onClick(this.bookState)) continue;
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)guideBookButton.getSound(), (float)1.0f));
            this.bookState.getGlobalPage(prevPage).onDepart();
            this.bookState.getCurrentPage().onArrive();
            return true;
        }
        for (GuideBookButton guideBookButton : this.cachedPage.extraButtons()) {
            if (!guideBookButton.boundingBox(this.leftPos, this.topPos).containsPoint((int)mouseX, (int)mouseY) || !guideBookButton.onClick(this.bookState)) continue;
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)guideBookButton.getSound(), (float)1.0f));
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, mouseAction);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (super.mouseScrolled(mouseX, mouseY, scrollX, scrollY)) {
            return true;
        }
        if (scrollY < 0.0) {
            this.bookState.incrementPage();
        } else {
            this.bookState.decrementPage();
        }
        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.BOOK_PAGE_TURN, (float)1.0f));
        return true;
    }

    public boolean isPauseScreen() {
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        InputConstants.Key mouseKey = InputConstants.getKey((int)keyCode, (int)scanCode);
        if (super.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.minecraft.options.keyInventory.isActiveAndMatches(mouseKey)) {
            this.onClose();
            return true;
        }
        return false;
    }

    public GuideBookState createGuidebookState() {
        Registry<MaterialDefinition> materialRegistry = IronsJewelryRegistries.materialRegistry(Minecraft.getInstance().level.registryAccess());
        Registry<PatternDefinition> patternRegistry = IronsJewelryRegistries.patternRegistry(Minecraft.getInstance().level.registryAccess());
        ArrayList<Page> materialPages = new ArrayList<Page>();
        materialRegistry.holders().filter(holder -> !((MaterialDefinition)holder.value()).ingredient().hasNoItems()).forEach(holder -> materialPages.add(new MaterialPage((Holder<MaterialDefinition>)holder)));
        ArrayList<Function<TableOfContentsPage.EntryPreparation, GuideBookButton>> materialTableOfContentsEntries = new ArrayList<Function<TableOfContentsPage.EntryPreparation, GuideBookButton>>();
        for (int i = 0; i < materialPages.size(); ++i) {
            MaterialPage materialPage = (MaterialPage)materialPages.get(i);
            Holder<MaterialDefinition> material = materialPage.material;
            materialTableOfContentsEntries.add(preparation -> new TextButton(preparation.x(), preparation.y(), preparation.width(), preparation.height(), (Component)Component.translatable((String)((MaterialDefinition)material.value()).descriptionId()), -16777216, ChatFormatting.YELLOW.getColor(), List.of(((MaterialDefinition)material.value()).ingredient().getItems()), guidebook -> guidebook.navigateToPage(materialPage)));
        }
        materialPages.addAll(0, this.createTableOfContentsPages((Component)Component.translatable((String)"ui.irons_jewelry.guide_book.table_of_contents_materials"), materialTableOfContentsEntries, 75));
        ArrayList<Page> patternPages = new ArrayList<Page>();
        patternRegistry.holders().forEach(holder -> patternPages.add(new PatternPage((Holder<PatternDefinition>)holder)));
        ArrayList<Function<TableOfContentsPage.EntryPreparation, GuideBookButton>> patternTableOfContentsEntries = new ArrayList<Function<TableOfContentsPage.EntryPreparation, GuideBookButton>>();
        for (int i = 0; i < patternPages.size(); ++i) {
            PatternPage patternPage = (PatternPage)patternPages.get(i);
            Holder<PatternDefinition> pattern = patternPage.pattern;
            patternTableOfContentsEntries.add(preparation -> new TextButton(preparation.x(), preparation.y(), preparation.width(), preparation.height(), (Component)Component.translatable((String)((PatternDefinition)pattern.value()).descriptionId()), -16777216, ChatFormatting.YELLOW.getColor(), List.of(patternPage.itemIcon), guidebook -> guidebook.navigateToPage(patternPage)));
        }
        patternPages.addAll(0, this.createTableOfContentsPages((Component)Component.translatable((String)"ui.irons_jewelry.guide_book.table_of_contents_patterns"), patternTableOfContentsEntries, 75));
        ArrayList<Page> masterTableOfContentsPages = new ArrayList<Page>();
        masterTableOfContentsPages.addAll(this.createTableOfContentsPages((Component)Component.translatable((String)"ui.irons_jewelry.guide_book.table_of_contents"), List.of(preparation -> new TextButton(preparation.x(), preparation.y(), preparation.width(), preparation.height(), (Component)Component.translatable((String)"ui.irons_jewelry.guide_book.table_of_contents_materials"), -16777216, ChatFormatting.YELLOW.getColor(), ItemRegistry.items().stream().filter(holder -> holder.is(Tags.Items.GEMS)).map(DeferredHolder::get).map(Item::getDefaultInstance).toList(), guidebook -> guidebook.navigateToPage((Page)materialPages.get(0))), preparation -> new TextButton(preparation.x(), preparation.y(), preparation.width(), preparation.height(), (Component)Component.translatable((String)"ui.irons_jewelry.guide_book.table_of_contents_patterns"), -16777216, ChatFormatting.YELLOW.getColor(), List.of(((PatternRecipeItem)((Object)((Object)ItemRegistry.RECIPE.get()))).getDefaultInstance()), guidebook -> guidebook.navigateToPage((Page)patternPages.get(0)))), 75));
        return new GuideBookState(List.of(new GuideBookState.BookSection(masterTableOfContentsPages), new GuideBookState.BookSection(materialPages), new GuideBookState.BookSection(patternPages)));
    }

    private List<TableOfContentsPage> createTableOfContentsPages(Component title, List<Function<TableOfContentsPage.EntryPreparation, GuideBookButton>> entries, int width) {
        int startingX = 15;
        int availableWidth = 267 - startingX - 15;
        int startingY = 7 + (int)(16.0f * this.itemScale) + 10;
        int availableHeight = 210 - startingY - 30;
        int entryWidth = width;
        int entryHeight = 16;
        int xMargin = Math.max(3, (availableWidth - entryWidth * 3) / 2 - 1);
        int yMargin = 1;
        ArrayList<TableOfContentsPage> pages = new ArrayList<TableOfContentsPage>();
        ArrayList<GuideBookButton> workingButtons = new ArrayList<GuideBookButton>();
        int workingX = 0;
        int workingY = 0;
        for (int i = 0; i < entries.size(); ++i) {
            workingButtons.add(entries.get(i).apply(new TableOfContentsPage.EntryPreparation(workingX + startingX, workingY + startingY, entryWidth, entryHeight)));
            if ((workingY += entryHeight + yMargin) + entryHeight < availableHeight) continue;
            workingY = 0;
            if ((workingX += entryWidth + xMargin) + entryWidth < availableWidth) continue;
            workingX = 0;
            pages.add(new TableOfContentsPage(this, title, workingButtons));
            workingButtons.clear();
        }
        if (!workingButtons.isEmpty()) {
            pages.add(new TableOfContentsPage(this, title, workingButtons));
        }
        return pages;
    }

    private int scaleColor(int color, float scalar) {
        int r = (int)Math.clamp((float)(color >> 16 & 0xFF) * scalar, 0.0f, 255.0f);
        int g = (int)Math.clamp((float)(color >> 8 & 0xFF) * scalar, 0.0f, 255.0f);
        int b = (int)Math.clamp((float)(color & 0xFF) * scalar, 0.0f, 255.0f);
        return r << 16 | g << 8 | b;
    }

    private void drawLine(GuiGraphics graphics, int thickness, int startX, int startY, int endX, int endY, int startColor, int endColor) {
        graphics.drawManaged(() -> {
            VertexConsumer consumer = graphics.bufferSource().getBuffer(RenderType.gui());
            Vec3 startV = new Vec3((double)startX, (double)startY, 0.0);
            Vec3 endV = new Vec3((double)endX, (double)endY, 0.0);
            Vec3 line = endV.subtract(startV);
            Vec3 volume = line.normalize().cross(new Vec3(0.0, 0.0, 1.0)).scale((double)thickness / 2.0);
            Vec3[] corners = new Vec3[]{startV.add(volume), startV.subtract(volume), endV.subtract(volume), endV.add(volume)};
            Matrix4f matrix4f = graphics.pose().last().pose();
            consumer.addVertex(matrix4f, (float)corners[0].x, (float)corners[0].y, 0.0f).setColor(startColor);
            consumer.addVertex(matrix4f, (float)corners[1].x, (float)corners[1].y, 0.0f).setColor(startColor);
            consumer.addVertex(matrix4f, (float)corners[2].x, (float)corners[2].y, 0.0f).setColor(endColor);
            consumer.addVertex(matrix4f, (float)corners[3].x, (float)corners[3].y, 0.0f).setColor(endColor);
        });
    }

    private int generateTextColor(ResourceLocation palette) {
        block15: {
            try {
                int[] aint;
                Optional resource = Minecraft.getInstance().getResourceManager().getResource(SpriteSource.TEXTURE_ID_CONVERTER.idToFile(palette));
                if (!resource.isPresent()) break block15;
                try (InputStream inputstream = ((Resource)resource.get()).open();
                     NativeImage nativeimage = NativeImage.read((InputStream)inputstream);){
                    aint = nativeimage.getPixelsRGBA();
                }
                aint = Arrays.copyOf(aint, 5);
                int r = Arrays.stream(aint).map(i -> i & 0xFF).sum() / aint.length;
                int g = Arrays.stream(aint).map(i -> i >> 8 & 0xFF).sum() / aint.length;
                int b = Arrays.stream(aint).map(i -> i >> 16 & 0xFF).sum() / aint.length;
                int max = Math.max(Math.max(r, g), b);
                if (max < 128) {
                    int factor = 128 / max;
                    r *= factor;
                    b *= factor;
                    g *= factor;
                }
                return -16777216 + (r << 16) + (g << 8) + b;
            }
            catch (Exception exception) {
                IronsJewelry.LOGGER.error("Failed to generate guidebook coloration for material palette: \"{}\"", (Object)palette);
            }
        }
        return 0xFFFFFF;
    }

    class BookmarkButton
    implements GuideBookButton {
        final int x;
        final int y;
        final int width;
        final int height;
        final ResourceLocation sprite;
        final ResourceLocation spriteActive;
        int bookmark;

        public BookmarkButton(int x, int y, int width, int height, ResourceLocation sprite, ResourceLocation spriteActive) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.sprite = sprite;
            this.spriteActive = spriteActive;
            this.bookmark = PlayerData.get((Player)Minecraft.getInstance().player).getBookmarkIndex();
        }

        @Override
        public ScreenRectangle boundingBox() {
            return ScreenRectangle.of((ScreenAxis)ScreenAxis.HORIZONTAL, (int)this.x, (int)this.y, (int)this.width, (int)this.height);
        }

        @Override
        public void render(GuiGraphics guiGraphics, boolean selected, float partialTick) {
            boolean active = this.bookmark >= 0 && this.bookmark == GuideBookScreen.this.bookState.getGlobalPageNumber() - 1;
            ResourceLocation sprite = active ? this.spriteActive : this.sprite;
            guiGraphics.blitSprite(sprite, this.x, this.y, this.width, this.height);
        }

        @Override
        public boolean onClick(GuideBookState state) {
            int bookmarkedIndex;
            PlayerData data = PlayerData.get((Player)Minecraft.getInstance().player);
            int currentPageIndex = state.getGlobalPageNumber() - 1;
            if (currentPageIndex != (bookmarkedIndex = data.getBookmarkIndex())) {
                GuideBookScreen.this.setBookmark(currentPageIndex);
                this.bookmark = currentPageIndex;
            } else {
                GuideBookScreen.this.setBookmark(-1);
                this.bookmark = -1;
            }
            return true;
        }
    }

    abstract class Page {
        Page() {
        }

        abstract void render(GuiGraphics var1, int var2, int var3, int var4, int var5, float var6);

        void drawTitle(GuiGraphics guiGraphics, Component text, int titleX, int titleBottomY, int color, boolean dropshadow, @Nullable CyclicItemRenderer itemRenderer) {
            int xOffset;
            PoseStack poseStack = guiGraphics.pose();
            poseStack.pushPose();
            float textScale = GuideBookScreen.this.titleScale;
            if (itemRenderer == null) {
                xOffset = 3;
            } else {
                xOffset = (int)(18.0f * GuideBookScreen.this.itemScale);
                itemRenderer.renderBottomLeft(guiGraphics, titleX, titleBottomY, GuideBookScreen.this.itemScale);
            }
            poseStack.scale(textScale *= Math.clamp((float)GuideBookScreen.this.getMaxTitleWidth() / (float)GuideBookScreen.this.font.width((FormattedText)text), 0.0f, 1.0f), textScale, textScale);
            Font font = GuideBookScreen.this.font;
            int n = (int)((float)(titleX + xOffset) / textScale);
            int n2 = (int)(((float)titleBottomY - 2.0f * GuideBookScreen.this.itemScale) / textScale);
            Objects.requireNonNull(GuideBookScreen.this.font);
            guiGraphics.drawString(font, text, n, n2 - 9, color, dropshadow);
            poseStack.popPose();
            int lineLength = Math.min((int)((float)xOffset + (float)(GuideBookScreen.this.font.width((FormattedText)text) + 24) * textScale), 237);
            int lineThickness = 2;
            int split = 15;
            int color2 = color & 0xFFFFFF;
            GuideBookScreen.this.drawLine(guiGraphics, lineThickness, titleX - 3, titleBottomY, titleX + split, titleBottomY, color2, color);
            GuideBookScreen.this.drawLine(guiGraphics, lineThickness, titleX + split, titleBottomY, titleX + lineLength, titleBottomY, color, color2);
        }

        void onArrive() {
        }

        void onDepart() {
        }

        List<? extends GuideBookButton> extraButtons() {
            return List.of();
        }
    }

    public class MaterialPage
    extends Page {
        final Holder<MaterialDefinition> material;
        final int cachedTextColor;
        final CyclicItemRenderer itemRenderer;
        final List<TableEntry> bonusTable;

        public MaterialPage(Holder<MaterialDefinition> material) {
            this.material = material;
            this.cachedTextColor = GuideBookScreen.this.generateTextColor(((MaterialDefinition)material.value()).paletteLocation());
            this.itemRenderer = new CyclicItemRenderer(List.of(((MaterialDefinition)material.value()).ingredient().getItems()));
            this.bonusTable = new ArrayList<TableEntry>();
            this.bonusTable.add(new TableEntry(Component.translatable((String)"ui.irons_jewelry.quality"), Component.literal((String)"x").append(String.valueOf(((MaterialDefinition)material.value()).quality())), Component.translatable((String)"ui.irons_jewelry.quality.description", (Object[])new Object[]{Component.translatable((String)((MaterialDefinition)material.value()).descriptionId()).withColor(this.cachedTextColor), Component.literal((String)String.valueOf(((MaterialDefinition)material.value()).quality())).withColor(this.cachedTextColor)}).withStyle(ChatFormatting.GRAY)));
            for (Map.Entry<IBonusParameterType<?>, Object> entry : ((MaterialDefinition)material.value()).bonusParameters().entrySet()) {
                Object value;
                IBonusParameterType<?> param = entry.getKey();
                Optional<Component> opt = param.getSimpleDescription(value = entry.getValue());
                if (!opt.isPresent()) continue;
                MutableComponent typeName = Component.translatable((String)param.getDescriptionId());
                this.bonusTable.add(new TableEntry(typeName, opt.get().copy(), Component.translatable((String)"ui.irons_jewelry.bonus_type.description", (Object[])new Object[]{typeName.copy().withColor(this.cachedTextColor), Component.translatable((String)((MaterialDefinition)material.value()).descriptionId()).withColor(this.cachedTextColor), Component.literal((String)opt.get().copy().getString()).withColor(this.cachedTextColor)}).withStyle(ChatFormatting.GRAY)));
            }
        }

        @Override
        public void render(GuiGraphics guiGraphics, int titleX, int titleBottomY, int mouseX, int mouseY, float partialTick) {
            MaterialDefinition material = (MaterialDefinition)this.material.value();
            MutableComponent name = Component.translatable((String)material.descriptionId());
            PoseStack poseStack = guiGraphics.pose();
            this.drawTitle(guiGraphics, (Component)name, titleX, titleBottomY, this.cachedTextColor, true, this.itemRenderer);
            float f = GuideBookScreen.this.topPos + 15;
            Objects.requireNonNull(GuideBookScreen.this.font);
            float f2 = f + 9.0f * (1.0f + GuideBookScreen.this.itemScale);
            Objects.requireNonNull(GuideBookScreen.this.font);
            int ypos = (int)(f2 + 9.0f / 2.0f);
            int bonusTypeMaxWidth = this.bonusTable.stream().map(TableEntry::type).mapToInt(arg_0 -> ((Font)GuideBookScreen.this.font).width(arg_0)).max().orElse(0);
            int valueColumMargin = bonusTypeMaxWidth + 8;
            int tooltipIndex = -1;
            int lightColor = GuideBookScreen.this.scaleColor(this.cachedTextColor, 1.75f);
            int darkColor = GuideBookScreen.this.scaleColor(this.cachedTextColor, 0.2f);
            for (int i = 0; i < this.bonusTable.size(); ++i) {
                TableEntry entry = this.bonusTable.get(i);
                MutableComponent type = entry.type;
                MutableComponent value = Component.literal((String)entry.value.getString());
                int xpos = GuideBookScreen.this.leftPos + 15;
                for (int x = -1; x <= 1; ++x) {
                    for (int y = -1; y <= 1; ++y) {
                        guiGraphics.drawString(GuideBookScreen.this.font, (Component)type, xpos + x, ypos + y, darkColor, false);
                    }
                }
                guiGraphics.drawString(GuideBookScreen.this.font, (Component)type, xpos, ypos, lightColor, false);
                if (mouseY >= ypos) {
                    Objects.requireNonNull(GuideBookScreen.this.font);
                    if (mouseY <= ypos + 9 && mouseX >= xpos && mouseX <= xpos + GuideBookScreen.this.font.width((FormattedText)type)) {
                        tooltipIndex = i;
                    }
                }
                int availableInfoWidth = 237 - valueColumMargin;
                for (FormattedCharSequence line : GuideBookScreen.this.font.split((FormattedText)value, availableInfoWidth)) {
                    guiGraphics.drawString(GuideBookScreen.this.font, line, xpos + valueColumMargin, ypos, 0, false);
                    if (mouseY >= ypos) {
                        Objects.requireNonNull(GuideBookScreen.this.font);
                        if (mouseY <= ypos + 9 && mouseX >= xpos + valueColumMargin && mouseX <= xpos + valueColumMargin + GuideBookScreen.this.font.width(line)) {
                            tooltipIndex = i;
                        }
                    }
                    Objects.requireNonNull(GuideBookScreen.this.font);
                    ypos += 9;
                }
                if (i == this.bonusTable.size() - 1) continue;
                int color = this.cachedTextColor;
                int color2 = color & 0xFFFFFF;
                int split = (xpos + valueColumMargin + xpos) / 2;
                GuideBookScreen.this.drawLine(guiGraphics, 1, xpos - 10, ++ypos, split, ypos, color2, color);
                GuideBookScreen.this.drawLine(guiGraphics, 1, split, ypos, xpos + valueColumMargin + availableInfoWidth / 2, ypos, color, color2);
                ypos += 2;
            }
            if (tooltipIndex >= 0) {
                guiGraphics.renderTooltip(GuideBookScreen.this.font, GuideBookScreen.this.font.split((FormattedText)this.bonusTable.get((int)tooltipIndex).tooltip, 250), mouseX, mouseY);
            }
        }

        record TableEntry(MutableComponent type, MutableComponent value, MutableComponent tooltip) {
        }
    }

    public class PatternPage
    extends Page {
        static final CyclicItemRenderer SCROLL_RENDERER = new CyclicItemRenderer(List.of(((PatternRecipeItem)((Object)ItemRegistry.RECIPE.get())).getDefaultInstance()));
        final Holder<PatternDefinition> pattern;
        final ItemStack itemIcon;
        final CyclicItemRenderer itemRenderer;
        final List<PartInfo> partInfo;
        final List<MutableComponent> overviewInfo;
        final List<FormattedCharSequence> patternTooltip;
        final int titleColor;
        int selectedPartIndex = -1;

        public PatternPage(Holder<PatternDefinition> pattern) {
            this.pattern = pattern;
            this.itemIcon = PatternPage.createPatternItem(pattern);
            this.itemRenderer = new CyclicItemRenderer(List.of(this.itemIcon));
            JewelryData data = JewelryData.get(this.itemIcon);
            List<PartIngredient> partKeys = ((PatternDefinition)pattern.value()).partTemplate().stream().sorted(Comparator.comparingInt(PartIngredient::drawOrder)).toList();
            this.titleColor = GuideBookScreen.this.generateTextColor(((MaterialDefinition)data.parts().get(partKeys.get(0).part()).value()).paletteLocation());
            this.partInfo = this.createPartInfo(data, partKeys);
            this.overviewInfo = this.createOverviewInfo(pattern, this.titleColor);
            this.patternTooltip = this.createPatternTooltip();
        }

        private List<FormattedCharSequence> createPatternTooltip() {
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            MutableComponent name = Component.translatable((String)((PatternDefinition)this.pattern.value()).descriptionId()).withColor(this.titleColor);
            if (((PatternDefinition)this.pattern.value()).unlockedByDefault()) {
                tooltip.add(Component.translatable((String)"ui.irons_jewelry.artisan_scroll_description.unlocked", (Object[])new Object[]{name, Component.translatable((String)"block.irons_jewelry.jewelcrafting_station").withColor(this.titleColor)}).withStyle(ChatFormatting.GRAY));
            } else {
                tooltip.add(Component.translatable((String)"ui.irons_jewelry.artisan_scroll_description.locked", (Object[])new Object[]{name, Component.translatable((String)"item.irons_jewelry.recipe").withColor(this.titleColor)}).withStyle(ChatFormatting.GRAY));
                tooltip.add(Component.empty());
                String descriptionId = ((PatternDefinition)this.pattern.value()).descriptionId() + ".guide";
                if (I18n.exists((String)descriptionId)) {
                    tooltip.add(Component.translatable((String)descriptionId).withStyle(ChatFormatting.GRAY));
                } else {
                    tooltip.add(Component.translatable((String)"ui.irons_jewelry.artisan_scroll_description.unknown").withStyle(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
                }
            }
            return tooltip.stream().flatMap(c -> c.getContents() == PlainTextContents.EMPTY ? Stream.of(FormattedCharSequence.EMPTY) : Minecraft.getInstance().font.split((FormattedText)c, 250).stream()).toList();
        }

        private List<PartInfo> createPartInfo(JewelryData jewelryData, List<PartIngredient> partIngredients) {
            ArrayList<PartInfo> partInfo = new ArrayList<PartInfo>(((PatternDefinition)this.pattern.value()).partTemplate().size());
            JewelryAssetHandler handler = AssetHandlerRegistry.JEWELRY_HANDLER.get();
            for (int i = 0; i < partIngredients.size(); ++i) {
                PartIngredient partIngredient = partIngredients.get(i);
                Holder<PartDefinition> part = partIngredient.part();
                ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
                Holder<MaterialDefinition> material = jewelryData.parts().get(part);
                boolean isPrimaryPart = ((PatternDefinition)this.pattern.value()).partForQuality().map(holder -> holder == part).orElse(false);
                MutableComponent name = Component.translatable((String)((PartDefinition)part.value()).descriptionId()).withStyle(ChatFormatting.UNDERLINE).withColor(GuideBookScreen.this.generateTextColor(((MaterialDefinition)material.value()).paletteLocation()));
                tooltip.add(name);
                tooltip.add(Component.literal((String)" ").append((Component)Component.translatable((String)"tooltip.irons_jewelry.material_cost", (Object[])new Object[]{Component.literal((String)String.valueOf(partIngredient.materialCost())).withStyle(ChatFormatting.WHITE)})).withStyle(ChatFormatting.GRAY));
                tooltip.add(Component.translatable((String)"tooltip.irons_jewelry.applicable_materials").withStyle(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.UNDERLINE}));
                IronsJewelryRegistries.materialRegistry(Minecraft.getInstance().level.registryAccess()).stream().filter(materialDefinition -> !materialDefinition.ingredient().hasNoItems() && ((PartDefinition)part.value()).canUseMaterial(materialDefinition.materialType())).forEach(m -> tooltip.add(Component.literal((String)" ").append((Component)Component.translatable((String)m.descriptionId())).withStyle(ChatFormatting.GRAY)));
                ArrayList<MutableComponent> partExpandedInfo = new ArrayList<MutableComponent>();
                partExpandedInfo.add(name);
                if (isPrimaryPart) {
                    partExpandedInfo.add(Component.empty());
                    partExpandedInfo.add(Component.translatable((String)"ui.irons_jewelry.primary_part_header").withStyle(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.UNDERLINE}));
                    partExpandedInfo.add(Component.translatable((String)"ui.irons_jewelry.primary_part.description").withStyle(ChatFormatting.GRAY));
                }
                partExpandedInfo.add(Component.empty());
                partExpandedInfo.add(Component.translatable((String)"tooltip.irons_jewelry.material_cost_header").withStyle(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.UNDERLINE}));
                partExpandedInfo.add(Component.translatable((String)"tooltip.irons_jewelry.material_cost", (Object[])new Object[]{partIngredient.materialCost()}).withStyle(ChatFormatting.GRAY));
                double patternBonus = ((PatternDefinition)this.pattern.value()).qualityMultiplier();
                if (!partIngredient.bonuses().isEmpty()) {
                    partExpandedInfo.add(Component.empty());
                    partExpandedInfo.add(Component.translatable((String)"tooltip.irons_jewelry.bonus_from_part_header").withStyle(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.UNDERLINE}));
                    for (Bonus bonus : partIngredient.bonuses()) {
                        MutableComponent component;
                        if (bonus.parameterValue().containsKey(bonus.bonusType().getParameterType())) {
                            BonusType bonusType = bonus.bonusType();
                            component = Component.translatable((String)"tooltip.irons_jewelry.bonus_with_direct_source", (Object[])new Object[]{Component.translatable((String)bonusType.getDescriptionId()), bonusType.getParameterType().getSimpleDescriptionCast(bonus.parameterValue().get(bonusType.getParameterType())).orElse((Component)Component.empty())});
                        } else {
                            component = Component.translatable((String)bonus.bonusType().getDescriptionId());
                        }
                        if (patternBonus * bonus.qualityMultiplier() != 1.0 && bonus.bonusType().getParameterType() != ParameterTypeRegistry.EMPTY.get()) {
                            component = component.append((Component)Component.literal((String)String.format(" (x%s)", patternBonus * bonus.qualityMultiplier())));
                        }
                        partExpandedInfo.add(component.withStyle(ChatFormatting.GRAY));
                    }
                }
                partInfo.add(new PartInfo(handler.getSprite(handler.getSpriteLocation(part, material)), Utils.rasterizeComponentList(tooltip), name, partExpandedInfo, isPrimaryPart, new PartSelectionButton(i)));
            }
            return partInfo;
        }

        private List<MutableComponent> createOverviewInfo(Holder<PatternDefinition> pattern, int titleColor) {
            ArrayList<MutableComponent> overviewInfo = new ArrayList<MutableComponent>();
            overviewInfo.add(Component.translatable((String)"tooltip.irons_jewelry.overview_header").withStyle(ChatFormatting.UNDERLINE).withColor(titleColor));
            List<MutableComponent> bonusTooltip = ((PatternDefinition)this.pattern.value()).getPatternBonusesTooltip();
            bonusTooltip.set(0, Component.translatable((String)"tooltip.irons_jewelry.bonus_crafted_header").withStyle(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.UNDERLINE}));
            overviewInfo.add(Component.empty());
            overviewInfo.add(Component.translatable((String)"tooltip.irons_jewelry.jewelry_type_header").withStyle(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.UNDERLINE}));
            overviewInfo.add(Component.translatable((String)((PatternDefinition)pattern.value()).jewelryType().getCuriosSlotIdentifier().map(s -> String.format("curios.identifier.%s", s)).orElse("Unknown")).withStyle(ChatFormatting.GRAY));
            overviewInfo.add(Component.empty());
            overviewInfo.addAll(bonusTooltip);
            overviewInfo.add(Component.empty());
            overviewInfo.add(Component.empty());
            overviewInfo.add(Component.translatable((String)"ui.irons_jewelry.guide_book.pattern_select_hint").withStyle(ChatFormatting.ITALIC).withColor(titleColor));
            return overviewInfo;
        }

        @Override
        void onDepart() {
            this.selectedPartIndex = -1;
        }

        @Override
        public void render(GuiGraphics guiGraphics, int titleX, int titleBottomY, int mouseX, int mouseY, float partialTick) {
            int borderend;
            int borderstart;
            int bgend;
            int bgstart;
            PatternDefinition pattern = (PatternDefinition)this.pattern.value();
            MutableComponent name = Component.translatable((String)pattern.descriptionId());
            this.drawTitle(guiGraphics, (Component)name, titleX, titleBottomY, this.titleColor, true, this.itemRenderer);
            int partSectionX = titleX;
            int partSectionY = titleBottomY + 4;
            int partSectionWidth = 100;
            Objects.requireNonNull(GuideBookScreen.this.font);
            int titleSpacer = 9 * 3 / 2;
            guiGraphics.drawString(GuideBookScreen.this.font, (Component)Component.translatable((String)"tooltip.irons_jewelry.parts_header").withStyle(ChatFormatting.UNDERLINE), partSectionX, partSectionY, 0, false);
            int yoff = 0;
            for (int i = 0; i < this.partInfo.size(); ++i) {
                int x = partSectionX;
                int y = partSectionY + titleSpacer + yoff;
                PartInfo info = this.partInfo.get(i);
                info.button.rectangle = ScreenRectangle.of((ScreenAxis)ScreenAxis.HORIZONTAL, (int)(x - GuideBookScreen.this.leftPos), (int)(y - GuideBookScreen.this.topPos), (int)partSectionWidth, (int)24);
                if (i == this.selectedPartIndex) {
                    bgend = bgstart = -1155133684;
                    borderstart = -572470625;
                    borderend = -291466894;
                    guiGraphics.drawManaged(() -> TooltipRenderUtil.renderTooltipBackground((GuiGraphics)guiGraphics, (int)x, (int)y, (int)(partSectionWidth - 5), (int)24, (int)0, (int)bgstart, (int)bgend, (int)borderstart, (int)borderend));
                }
                info.render(guiGraphics, x, y, partSectionWidth, mouseX, mouseY, partialTick);
                yoff += 32;
            }
            int infoSectionX = titleX + partSectionWidth + 1;
            int infoSectionY = partSectionY + 3;
            int infoSectionWidth = 256 - (infoSectionX - GuideBookScreen.this.leftPos);
            int infoSectionHeight = 180 - (infoSectionY - GuideBookScreen.this.topPos);
            bgend = bgstart = -584708340;
            borderstart = -2045281;
            borderend = -6254222;
            guiGraphics.drawManaged(() -> TooltipRenderUtil.renderTooltipBackground((GuiGraphics)guiGraphics, (int)infoSectionX, (int)(infoSectionY + 1), (int)(infoSectionWidth - 2), (int)(infoSectionHeight - 2), (int)0, (int)bgstart, (int)bgend, (int)borderstart, (int)borderend));
            List<MutableComponent> infoPage = this.overviewInfo;
            if (this.selectedPartIndex >= 0 && this.selectedPartIndex < this.partInfo.size()) {
                infoPage = this.partInfo.get((int)this.selectedPartIndex).expandedInfo;
            }
            int emptyMargin = 4;
            TextStack stack = TextStack.textStack(new LinkedList<MutableComponent>(infoPage), emptyMargin);
            float textScale = 1.0f;
            while ((double)textScale > 0.1) {
                float f = (float)stack.getTotalHeight(GuideBookScreen.this.font, (int)((float)infoSectionWidth / textScale)) * textScale;
                Objects.requireNonNull(GuideBookScreen.this.font);
                if (!(f > (float)(infoSectionHeight - 9))) break;
                textScale -= 0.1f;
            }
            PoseStack poseStack = guiGraphics.pose();
            poseStack.pushPose();
            poseStack.translate((float)infoSectionX, (float)infoSectionY, 0.0f);
            poseStack.scale(textScale, textScale, textScale);
            int y = 0;
            for (MutableComponent component : infoPage) {
                if (component.getContents() == PlainTextContents.EMPTY) {
                    y += emptyMargin;
                    continue;
                }
                for (FormattedCharSequence line : GuideBookScreen.this.font.split((FormattedText)component, (int)((float)infoSectionWidth / textScale))) {
                    guiGraphics.drawString(GuideBookScreen.this.font, line, 0, y, -1, true);
                    Objects.requireNonNull(GuideBookScreen.this.font);
                    y += 9 + 1;
                }
            }
            poseStack.popPose();
            poseStack.pushPose();
            float scale = GuideBookScreen.this.itemScale * 0.75f;
            int itemX = (int)((float)(GuideBookScreen.this.leftPos + 267 - 15) - 16.0f * scale);
            poseStack.translate(0.0f, 0.0f, -2000.0f);
            SCROLL_RENDERER.renderBottomLeft(guiGraphics, itemX, titleBottomY, scale);
            poseStack.translate(0.0f, 0.0f, 1000.0f);
            poseStack.scale(scale, scale, scale);
            Font font = GuideBookScreen.this.font;
            float f = (float)(itemX + 22) / scale;
            float f2 = titleBottomY;
            Objects.requireNonNull(GuideBookScreen.this.font);
            guiGraphics.drawString(font, "?", f, (f2 - 9.0f * scale) / scale, 0, false);
            poseStack.popPose();
            if (mouseX >= itemX && (float)mouseX <= (float)itemX + 22.0f * scale && (float)mouseY >= (float)titleBottomY - 16.0f * scale && mouseY <= titleBottomY) {
                guiGraphics.renderTooltip(GuideBookScreen.this.font, this.patternTooltip, mouseX, mouseY);
            }
        }

        private static ItemStack createPatternItem(Holder<PatternDefinition> pattern) {
            try {
                ItemStack item = new ItemStack(((PatternDefinition)pattern.value()).jewelryType().item());
                Holder.Reference renderMaterial = null;
                Registry<MaterialDefinition> materialRegistry = IronsJewelryRegistries.materialRegistry(Minecraft.getInstance().level.registryAccess());
                Holder.Reference metal = (Holder.Reference)materialRegistry.getHolder(IronsJewelry.id("gold")).get();
                Holder.Reference gem = (Holder.Reference)materialRegistry.getHolder(IronsJewelry.id("diamond")).get();
                HashMap<Holder<PartDefinition>, Holder<MaterialDefinition>> parts = new HashMap<Holder<PartDefinition>, Holder<MaterialDefinition>>();
                for (PartIngredient partIngredient : ((PatternDefinition)pattern.value()).partTemplate()) {
                    Holder<PartDefinition> part = partIngredient.part();
                    if (((PartDefinition)part.value()).canUseMaterial("metal")) {
                        renderMaterial = metal;
                    } else if (((PartDefinition)part.value()).canUseMaterial("gem")) {
                        renderMaterial = gem;
                    } else {
                        for (MaterialDefinition materialDefinition : materialRegistry) {
                            if (!((PartDefinition)part.value()).canUseMaterial(materialDefinition.materialType())) continue;
                            renderMaterial = materialRegistry.wrapAsHolder((Object)materialDefinition);
                            break;
                        }
                        Objects.requireNonNull(renderMaterial, "No valid material found for part \"" + String.valueOf(part.getKey()) + "\"");
                    }
                    parts.put(part, (Holder<MaterialDefinition>)renderMaterial);
                }
                JewelryData data = JewelryData.renderable(pattern, parts);
                JewelryData.set(item, data);
                return item;
            }
            catch (Exception e) {
                IronsJewelry.LOGGER.error("Failed to generate guidebook pattern preview: {}", (Object)e.getMessage());
                return ItemStack.EMPTY;
            }
        }

        @Override
        List<? extends GuideBookButton> extraButtons() {
            return this.partInfo;
        }

        record PartInfo(TextureAtlasSprite sprite, List<FormattedCharSequence> tooltip, MutableComponent name, List<MutableComponent> expandedInfo, boolean primary, PartSelectionButton button) implements GuideBookButton
        {
            private static final ResourceLocation INPUT_SLOT = IronsJewelry.id("guidebook/guidebook_part_frame");

            void render(GuiGraphics guiGraphics, int x, int y, int width, int mouseX, int mouseY, float partialTick) {
                List<FormattedCharSequence> tooltipToRender = null;
                int slotMargin = 4;
                int size = 24;
                guiGraphics.blitSprite(INPUT_SLOT, x, y, 200, size, size);
                guiGraphics.blit(x + slotMargin, y + slotMargin, 200, 16, 16, this.sprite);
                if (mouseX >= x && mouseX <= x + size && mouseY >= y && mouseY <= y + size) {
                    tooltipToRender = this.tooltip;
                }
                int textMargin = 3;
                x += size + textMargin;
                Font font = Minecraft.getInstance().font;
                int ypos = y;
                int textWidth = width - size - textMargin;
                for (FormattedCharSequence line : font.split((FormattedText)this.name, textWidth)) {
                    guiGraphics.drawString(font, line, x, ypos, 0, true);
                    Objects.requireNonNull(font);
                    ypos += 9;
                }
                if (this.primary) {
                    ++ypos;
                    for (FormattedCharSequence line : font.split((FormattedText)Component.translatable((String)"ui.irons_jewelry.primary_part").withStyle(ChatFormatting.ITALIC).withColor(-14540237), textWidth)) {
                        guiGraphics.drawString(font, line, x, ypos, 0, false);
                        Objects.requireNonNull(font);
                        ypos += 9;
                    }
                }
                if (tooltipToRender != null) {
                    guiGraphics.renderTooltip(Minecraft.getInstance().font, tooltipToRender, mouseX, mouseY);
                }
            }

            @Override
            public ScreenRectangle boundingBox() {
                return this.button.boundingBox();
            }

            @Override
            public void render(GuiGraphics guiGraphics, boolean selected, float partialTick) {
                this.button.render(guiGraphics, selected, partialTick);
            }

            @Override
            public boolean onClick(GuideBookState state) {
                return this.button.onClick(state);
            }

            @Override
            public SoundEvent getSound() {
                return (SoundEvent)SoundEvents.NOTE_BLOCK_HAT.value();
            }
        }

        class PartSelectionButton
        implements GuideBookButton {
            ScreenRectangle rectangle;
            final int navigateIndex;

            PartSelectionButton(int navigateIndex) {
                this.navigateIndex = navigateIndex;
                this.rectangle = ScreenRectangle.of((ScreenAxis)ScreenAxis.HORIZONTAL, (int)0, (int)0, (int)0, (int)0);
            }

            @Override
            public ScreenRectangle boundingBox() {
                return this.rectangle;
            }

            @Override
            public void render(GuiGraphics guiGraphics, boolean selected, float partialTick) {
            }

            @Override
            public boolean onClick(GuideBookState state) {
                PatternPage.this.selectedPartIndex = PatternPage.this.selectedPartIndex == this.navigateIndex ? -1 : this.navigateIndex;
                return true;
            }
        }

        static abstract class TextStack {
            @Nullable
            TextStack child;

            TextStack() {
            }

            private static TextStack textStack(Queue<? extends net.minecraft.network.chat.Component> lines, int space) {
                if (lines.isEmpty()) {
                    return null;
                }
                net.minecraft.network.chat.Component component = lines.poll();
                TextStack textStack = component.getContents() == PlainTextContents.EMPTY ? new Space(space) : new Component(component);
                textStack.child = TextStack.textStack(lines, space);
                return textStack;
            }

            abstract int getHeight(Font var1, int var2);

            int getTotalHeight(Font font, int width) {
                return this.getHeight(font, width) + (this.child == null ? 0 : this.child.getTotalHeight(font, width));
            }

            static class Space
            extends TextStack {
                final int space;

                Space(int space) {
                    this.space = space;
                }

                @Override
                int getHeight(Font font, int width) {
                    return this.space;
                }
            }

            static class Component
            extends TextStack {
                final net.minecraft.network.chat.Component component;

                Component(net.minecraft.network.chat.Component component) {
                    this.component = component;
                }

                @Override
                int getHeight(Font font, int width) {
                    int n = font.split((FormattedText)this.component, width).size();
                    Objects.requireNonNull(font);
                    return n * 9;
                }
            }
        }
    }

    public class TableOfContentsPage
    extends Page {
        final Component title;
        final List<GuideBookButton> entries;

        public TableOfContentsPage(GuideBookScreen this$0, Component title, List<GuideBookButton> entries) {
            this.title = title;
            this.entries = new ArrayList<GuideBookButton>();
            this.entries.addAll(entries);
        }

        @Override
        public void render(GuiGraphics guiGraphics, int titleX, int titleBottomY, int mouseX, int mouseY, float partialTick) {
            this.drawTitle(guiGraphics, this.title, titleX, titleBottomY, -7375509, true, null);
        }

        @Override
        public List<? extends GuideBookButton> extraButtons() {
            return this.entries;
        }

        public record EntryPreparation(int x, int y, int width, int height) {
        }
    }
}

