/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsjewelry.item.book;

import io.redspace.ironsjewelry.item.book.GuideBookScreen;
import java.util.List;

public class GuideBookState {
    final List<BookSection> sections;
    int sectionIndex;
    int localPageIndex;

    public GuideBookState(List<BookSection> sections) {
        this.sections = sections;
    }

    public BookSection getCurrentSection() {
        if (this.sections.isEmpty()) {
            throw new IllegalArgumentException("Cannot have empty book state!");
        }
        return this.sections.get(this.sectionIndex);
    }

    public GuideBookScreen.Page getCurrentPage() {
        BookSection section = this.getCurrentSection();
        if (section.pages.isEmpty()) {
            throw new IllegalArgumentException("Cannot have empty book section!");
        }
        return section.pages.get(this.localPageIndex);
    }

    public GuideBookScreen.Page getGlobalPage(int globalIndex) {
        int pageIndex = globalIndex;
        int i = 0;
        while (pageIndex >= this.sections.get((int)i).pages.size()) {
            pageIndex -= this.sections.get((int)i).pages.size();
            ++i;
        }
        if (i >= this.sections.size()) {
            throw new IllegalArgumentException("Accessing invalid page index: " + globalIndex);
        }
        return this.sections.get(i).pages().get(pageIndex);
    }

    public boolean incrementPage() {
        BookSection currentSection = this.sections.get(this.sectionIndex);
        if (this.localPageIndex + 1 >= currentSection.pages.size()) {
            if (this.sectionIndex < this.sections.size() - 1) {
                this.localPageIndex = 0;
                ++this.sectionIndex;
                return true;
            }
            return false;
        }
        ++this.localPageIndex;
        return true;
    }

    public boolean decrementPage() {
        --this.localPageIndex;
        if (this.localPageIndex == -1) {
            if (this.sectionIndex > 0) {
                --this.sectionIndex;
                this.localPageIndex = this.sections.get((int)this.sectionIndex).pages.size() - 1;
                return true;
            }
            this.localPageIndex = 0;
            return false;
        }
        return true;
    }

    public boolean setLocalPage(int page) {
        if (page >= 0 && page < this.sections.get((int)this.sectionIndex).pages.size()) {
            this.localPageIndex = page;
            return true;
        }
        return false;
    }

    public boolean navigateToPage(GuideBookScreen.Page page) {
        for (int j = 0; j < this.sections.size(); ++j) {
            BookSection section = this.sections.get(j);
            int i = section.pages.indexOf(page);
            if (i < 0) continue;
            this.localPageIndex = i;
            this.sectionIndex = j;
            return true;
        }
        return false;
    }

    public boolean returnSection() {
        if (this.localPageIndex == 0) {
            if (this.sectionIndex != 0) {
                this.sectionIndex = 0;
                return true;
            }
        } else {
            this.localPageIndex = 0;
            return true;
        }
        return false;
    }

    public int getGlobalPageNumber() {
        int page = 0;
        for (int i = 0; i < this.sectionIndex; ++i) {
            page += this.sections.get((int)i).pages.size();
        }
        return page += this.localPageIndex + 1;
    }

    public int getMaxPageCount() {
        int pages = 0;
        for (int i = 0; i < this.sections.size(); ++i) {
            pages += this.sections.get((int)i).pages.size();
        }
        return pages;
    }

    public record BookSection(List<GuideBookScreen.Page> pages) {
    }
}

