/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsjewelry.item.book.buttons;

import io.redspace.ironsjewelry.item.book.CyclicItemRenderer;
import io.redspace.ironsjewelry.item.book.GuideBookState;
import io.redspace.ironsjewelry.item.book.buttons.GuideBookButton;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenAxis;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class TextButton
implements GuideBookButton {
    final int x;
    final int y;
    final int width;
    final int height;
    final int color;
    final int selectedColor;
    @Nullable
    final CyclicItemRenderer itemRenderer;
    final Component text;
    final Function<GuideBookState, Boolean> onClick;

    public TextButton(int x, int y, int width, int height, Component text, int color, int selectedColor, List<ItemStack> itemIcons, Function<GuideBookState, Boolean> onClick) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.color = color;
        this.selectedColor = selectedColor;
        this.text = text;
        this.itemRenderer = itemIcons.isEmpty() ? null : new CyclicItemRenderer(itemIcons);
        this.onClick = onClick;
    }

    @Override
    public ScreenRectangle boundingBox() {
        return ScreenRectangle.of((ScreenAxis)ScreenAxis.HORIZONTAL, (int)this.x, (int)this.y, (int)this.width, (int)this.height);
    }

    @Override
    public void render(GuiGraphics guiGraphics, boolean selected, float partialTick) {
        int maxWidth = this.width;
        int textX = this.x;
        int middleY = this.y + this.height / 2;
        if (this.itemRenderer != null) {
            maxWidth -= 18;
            textX += 18;
            this.itemRenderer.renderBottomLeft(guiGraphics, this.x, middleY + 8, 1.0f);
        }
        Font font = Minecraft.getInstance().font;
        int textWidth = font.width((FormattedText)this.text);
        float textScale = Math.clamp((float)maxWidth / (float)textWidth, 0.0f, 1.0f);
        guiGraphics.pose().pushPose();
        guiGraphics.pose().scale(textScale, textScale, textScale);
        float f = middleY;
        Objects.requireNonNull(font);
        float textYBottom = f + 9.0f / 2.0f + 2.0f;
        int n = (int)((float)textX / textScale);
        float f2 = textYBottom / textScale;
        Objects.requireNonNull(font);
        guiGraphics.drawString(font, this.text, n, (int)(f2 - 9.0f), selected ? this.selectedColor : this.color, selected);
        guiGraphics.pose().popPose();
    }

    @Override
    public boolean onClick(GuideBookState state) {
        return this.onClick.apply(state);
    }
}

