/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.cognition.block;

import com.cyanogen.cognition.block_entities.ExperienceObeliskEntity;
import com.cyanogen.cognition.block_entities.ExperienceReceivingEntity;
import com.cyanogen.cognition.registries.RegisterItems;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;

public abstract class ExperienceReceivingBlock
extends Block {
    private ItemStack blockItem;

    public ExperienceReceivingBlock(BlockBehaviour.Properties p) {
        super(p);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity;
        if (stack.is((Item)RegisterItems.ATTUNEMENT_STAFF.get()) && !player.isShiftKeyDown() && (blockEntity = level.getBlockEntity(pos)) instanceof ExperienceReceivingEntity) {
            ExperienceReceivingEntity receiver = (ExperienceReceivingEntity)blockEntity;
            this.handleInfoRequest(receiver, player, level);
            return ItemInteractionResult.sidedSuccess((boolean)true);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void handleInfoRequest(ExperienceReceivingEntity entity, Player player, Level level) {
        if (entity.isBound()) {
            BlockPos boundPos = entity.getBoundPos();
            if (level.getBlockEntity(boundPos) instanceof ExperienceObeliskEntity) {
                player.displayClientMessage((Component)Component.translatable((String)"message.cognition.binding_wand.reveal_bound_pos", (Object[])new Object[]{Component.literal((String)boundPos.toShortString()).withStyle(ChatFormatting.GREEN)}), true);
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"message.cognition.binding_wand.obelisk_doesnt_exist", (Object[])new Object[]{Component.literal((String)boundPos.toShortString())}).withStyle(ChatFormatting.RED), true);
            }
        } else {
            player.displayClientMessage((Component)Component.translatable((String)"message.cognition.binding_wand.not_yet_bound"), true);
        }
    }

    public ItemStack getBlockItem() {
        return this.blockItem;
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.isClientSide) {
            BlockEntity entity = level.getBlockEntity(pos);
            if (player.hasCorrectToolForDrops(state, level, pos) && entity != null) {
                this.blockItem = new ItemStack((ItemLike)state.getBlock(), 1);
                entity.saveToItem(this.blockItem, (HolderLookup.Provider)level.registryAccess());
            }
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public void onBlockExploded(BlockState state, Level level, BlockPos pos, Explosion explosion) {
        BlockEntity entity;
        if (!level.isClientSide && (entity = level.getBlockEntity(pos)) != null) {
            this.blockItem = new ItemStack((ItemLike)state.getBlock(), 1);
            entity.saveToItem(this.blockItem, (HolderLookup.Provider)level.registryAccess());
        }
        super.onBlockExploded(state, level, pos, explosion);
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder params) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if (this.blockItem != null) {
            drops.add(this.blockItem);
            return drops;
        }
        return super.getDrops(state, params);
    }
}

