/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.cognition.block_entities;

import com.cyanogen.cognition.config.Config;
import com.cyanogen.cognition.registries.RegisterBlockEntities;
import com.cyanogen.cognition.registries.RegisterFluids;
import com.cyanogen.cognition.saved_data.MemoryTabletData;
import com.cyanogen.cognition.utils.ExperienceUtils;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ExperienceObeliskEntity
extends BlockEntity
implements GeoBlockEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected static final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    protected static final RawAnimation IDLE_INACTIVE = RawAnimation.begin().thenPlay("idle.inactive");
    protected boolean redstoneEnabled = false;
    protected double radius = 2.5;
    public final boolean clumpsIsLoaded;
    protected String savedPlayer = "";
    public static final BlockCapability<IFluidHandler, Direction> FLUID_HANDLER = Capabilities.FluidHandler.BLOCK;
    protected ExperienceObeliskTank tank = new ExperienceObeliskTank();
    private static final Fluid cognitium = (Fluid)RegisterFluids.COGNITIUM_SOURCE.get();
    public static final int capacity = (int)Math.min(Math.round((double)((Integer)Config.COMMON.capacity.get()).intValue() / 20.0) * 20L, 0x7FFFFFF8L);

    public ExperienceObeliskEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)RegisterBlockEntities.EXPERIENCE_OBELISK.get(), pos, state);
        this.clumpsIsLoaded = ModList.get().isLoaded("clumps");
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, this::controller));
    }

    protected <E extends ExperienceObeliskEntity> PlayState controller(AnimationState<E> state) {
        ExperienceObeliskEntity obelisk = (ExperienceObeliskEntity)state.getAnimatable();
        AnimationController controller = state.getController();
        RawAnimation animation = controller.getCurrentRawAnimation();
        if (animation == null || this.level == null) {
            controller.setAnimation(IDLE);
        } else if (controller.getAnimationState() == AnimationController.State.STOPPED || controller.getAnimationState() == AnimationController.State.PAUSED) {
            controller.forceAnimationReset();
            controller.setAnimation(IDLE);
        } else {
            boolean isInactive;
            boolean bl = isInactive = obelisk.redstoneEnabled && !this.level.hasNeighborSignal(obelisk.getBlockPos());
            if (isInactive && animation.equals((Object)IDLE)) {
                controller.setAnimation(IDLE_INACTIVE);
            } else if (!isInactive && animation.equals((Object)IDLE_INACTIVE)) {
                controller.setAnimation(IDLE);
            }
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public static <T> void tick(Level level, BlockPos pos, BlockState state, T blockEntity) {
        boolean isRedstonePowered = level.hasNeighborSignal(pos);
        if (blockEntity instanceof ExperienceObeliskEntity) {
            List list;
            ExperienceObeliskEntity obelisk = (ExperienceObeliskEntity)((Object)blockEntity);
            boolean absorb = !obelisk.isRedstoneEnabled() || isRedstonePowered;
            double radius = obelisk.getRadius();
            int space = obelisk.getSpace();
            if (absorb && level.getGameTime() % 10L == 0L && space > 0 && !(list = level.getEntitiesOfClass(ExperienceOrb.class, ExperienceObeliskEntity.getAreaOfEffect(pos, radius))).isEmpty()) {
                for (int i = 0; i < Math.min(64, list.size()); ++i) {
                    ExperienceOrb orb = (ExperienceOrb)list.get(i);
                    int value = obelisk.clumpsIsLoaded ? ExperienceUtils.getClumpedOrbValue(orb) : ExperienceUtils.getOrbValue(orb);
                    int amount = value * 20;
                    if (space < amount || orb.isRemoved()) continue;
                    obelisk.fill(amount);
                    space -= amount;
                    orb.discard();
                }
            }
            if (!level.isClientSide && space > 0) {
                obelisk.checkAroundForMemorized();
            }
        }
    }

    public static AABB getAreaOfEffect(BlockPos pos, double radius) {
        Vec3 ctr = pos.getCenter();
        return new AABB(ctr.x - (radius += 0.5), ctr.y - radius, ctr.z - radius, ctr.x + radius, ctr.y + radius, ctr.z + radius);
    }

    public boolean isRedstoneEnabled() {
        return this.redstoneEnabled;
    }

    public void setRedstoneEnabled(boolean state) {
        this.redstoneEnabled = state;
        this.setChanged();
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double radius) {
        this.radius = radius;
        this.setChanged();
    }

    public void setChanged() {
        if (this.level != null) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
        }
        super.setChanged();
    }

    public String getSavedPlayer() {
        return this.savedPlayer;
    }

    public void syncFromStorage() {
        MemoryTabletData data;
        if (this.level != null && (data = MemoryTabletData.getFromStorage(this.level, this.savedPlayer)) != null && data.hasLinkedObelisk() && data.getLinkedObelisk() != this.getBlockPos()) {
            this.savedPlayer = "";
            this.setChanged();
        }
    }

    public void remember(Player player, MemoryTabletData data) {
        this.savedPlayer = player.getStringUUID();
        if (data == null) {
            MemoryTabletData newData = new MemoryTabletData();
            newData.setLinkedObelisk(this.getBlockPos(), player.level().dimension().location().toString(), true);
            MemoryTabletData.createAndSaveToStorage(player, newData);
        } else {
            data.setLinkedObelisk(this.getBlockPos(), player.level().dimension().location().toString(), true);
        }
        this.setChanged();
    }

    public void forget(Player player, MemoryTabletData data) {
        this.savedPlayer = "";
        if (data == null) {
            MemoryTabletData newData = new MemoryTabletData();
            newData.setLinkedObelisk(new BlockPos(0, 0, 0), "minecraft:overworld", false);
            MemoryTabletData.createAndSaveToStorage(player, newData);
        } else {
            data.setLinkedObelisk(new BlockPos(0, 0, 0), "minecraft:overworld", false);
        }
        this.setChanged();
    }

    public void checkAroundForMemorized() {
        if (this.level != null && this.level.getGameTime() % 20L == 0L) {
            BlockPos pos = this.getBlockPos();
            List list = this.level.getEntitiesOfClass(Player.class, ExperienceObeliskEntity.getAreaOfEffect(pos, this.getRadius()));
            for (Player player : list) {
                MemoryTabletData data = MemoryTabletData.getFromStorage(player);
                if (data == null || player.isDeadOrDying() || !this.hasMemorized(data) || !this.hasXpToRecover(data)) continue;
                this.handleExperienceRecovery(player, data);
                break;
            }
        }
    }

    public boolean hasMemorized(MemoryTabletData data) {
        return data != null && data.getLinkedObelisk().equals((Object)this.getBlockPos());
    }

    public boolean hasXpToRecover(MemoryTabletData data) {
        return data != null && data.getExperienceToRecover() > 0L;
    }

    public void handleExperienceRecovery(Player player, MemoryTabletData data) {
        assert (data != null);
        long xp = data.getExperienceToRecover();
        int pointsToRecover = (int)Math.min((long)(this.getSpace() / 20), xp);
        player.giveExperiencePoints(pointsToRecover);
        assert (this.level != null);
        this.level.playSound(null, this.getBlockPos(), SoundEvents.PLAYER_LEVELUP, SoundSource.BLOCKS, 1.0f, 0.25f);
        ServerLevel server = (ServerLevel)this.level;
        BlockPos pos = this.getBlockPos();
        server.sendParticles((ServerPlayer)player, (ParticleOptions)ParticleTypes.TOTEM_OF_UNDYING, false, (double)pos.getX() + 0.5, (double)pos.getY() + 0.6, (double)pos.getZ() + 0.5, 64, 1.0, 1.0, 1.0, 0.1);
        data.setExperienceToRecover(0L);
        player.displayClientMessage((Component)Component.translatable((String)"message.cognition.experience_obelisk.experience_recovered", (Object[])new Object[]{Component.literal((String)String.valueOf(ExperienceUtils.xpToLevels(pointsToRecover))).withStyle(ChatFormatting.GREEN)}), true);
    }

    @Nullable
    public static IFluidHandler getCapability(ExperienceObeliskEntity obelisk, Direction direction) {
        return direction == null || !direction.equals((Object)Direction.UP) ? obelisk.tank : null;
    }

    public int fill(int amount) {
        return this.tank.fill(new FluidStack(cognitium, amount), IFluidHandler.FluidAction.EXECUTE);
    }

    public void drain(int amount) {
        this.tank.drain(new FluidStack(cognitium, amount), IFluidHandler.FluidAction.EXECUTE);
    }

    public void setFluid(int amount) {
        this.tank.setFluid(new FluidStack(cognitium, amount));
    }

    public int getFluidAmount() {
        return this.tank.getFluidAmount();
    }

    public int getSpace() {
        return this.tank.getSpace();
    }

    public int getExperiencePoints() {
        return this.getFluidAmount() / 20;
    }

    public int getLevels() {
        return ExperienceUtils.xpToLevels(this.getExperiencePoints());
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.tank.readFromNBT(provider, tag);
        this.savedPlayer = tag.getString("SavedPlayer");
        this.radius = tag.getDouble("Radius");
        this.redstoneEnabled = tag.getBoolean("isRedstoneControllable");
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        this.tank.writeToNBT(provider, tag);
        tag.putString("SavedPlayer", this.savedPlayer);
        tag.putDouble("Radius", this.radius);
        tag.putBoolean("isRedstoneControllable", this.redstoneEnabled);
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider provider) {
        super.handleUpdateTag(tag, provider);
        this.tank.readFromNBT(provider, tag);
        this.savedPlayer = tag.getString("SavedPlayer");
        this.radius = tag.getDouble("Radius");
        this.redstoneEnabled = tag.getBoolean("isRedstoneControllable");
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tag = super.getUpdateTag(provider);
        this.tank.writeToNBT(provider, tag);
        tag.putString("SavedPlayer", this.savedPlayer);
        tag.putDouble("Radius", this.radius);
        tag.putBoolean("isRedstoneControllable", this.redstoneEnabled);
        return tag;
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void handleRequest(String request, int levels, ServerPlayer sender) {
        long playerXP = ExperienceUtils.getTotalXP((Player)sender);
        if (Objects.equals(request, "FILL") && this.getSpace() != 0) {
            long finalXP = ExperienceUtils.levelsToXP(sender.experienceLevel - levels) + (long)Math.round(sender.experienceProgress * (float)(ExperienceUtils.levelsToXP(sender.experienceLevel - levels + 1) - ExperienceUtils.levelsToXP(sender.experienceLevel - levels)));
            long addAmount = (playerXP - finalXP) * 20L;
            if (sender.experienceLevel >= levels && addAmount >= (long)this.getSpace()) {
                sender.giveExperiencePoints(-this.fill(this.getSpace()) / 20);
            } else if (sender.experienceLevel >= levels) {
                this.fill((int)addAmount);
                sender.giveExperienceLevels(-levels);
            } else if (playerXP >= 1L) {
                this.fill((int)(playerXP * 20L));
                sender.setExperiencePoints(0);
                sender.setExperienceLevels(0);
            }
        } else if (Objects.equals(request, "DRAIN") && this.getFluidAmount() != 0) {
            long finalXP;
            long drainAmount;
            int amount = this.getFluidAmount();
            if ((long)amount >= (drainAmount = ((finalXP = ExperienceUtils.levelsToXP(sender.experienceLevel + levels) + (long)Math.round(sender.experienceProgress * (float)(ExperienceUtils.levelsToXP(sender.experienceLevel + levels + 1) - ExperienceUtils.levelsToXP(sender.experienceLevel + levels)))) - playerXP) * 20L)) {
                this.drain((int)drainAmount);
                sender.giveExperienceLevels(levels);
            } else if (amount >= 1) {
                sender.giveExperiencePoints(amount / 20);
                this.setFluid(0);
            }
        } else if (Objects.equals(request, "FILL_ALL") && this.getSpace() != 0) {
            if (playerXP * 20L <= (long)this.getSpace()) {
                this.fill((int)(playerXP * 20L));
                sender.setExperiencePoints(0);
                sender.setExperienceLevels(0);
            } else {
                sender.giveExperiencePoints(-this.getSpace() / 20);
                this.setFluid(capacity);
            }
        } else if (Objects.equals(request, "DRAIN_ALL") && this.getFluidAmount() != 0) {
            sender.giveExperiencePoints(this.getFluidAmount() / 20);
            this.setFluid(0);
        }
    }

    public class ExperienceObeliskTank
    extends FluidTank {
        public ExperienceObeliskTank() {
            super(capacity);
        }

        protected void onContentsChanged() {
            ExperienceObeliskEntity.this.setChanged();
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return this.isFluidValid(stack);
        }

        public boolean isFluidValid(FluidStack stack) {
            String fluidName = BuiltInRegistries.FLUID.getKey((Object)stack.getFluid()).toString();
            if (stack.getFluid() == cognitium) {
                return true;
            }
            return ((List)Config.COMMON.allowedFluids.get()).contains(fluidName);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (this.isFluidValid(resource)) {
                return super.fill(new FluidStack(cognitium, resource.getAmount()), action);
            }
            return 0;
        }

        public void setFluid(FluidStack stack) {
            this.fluid = stack;
            ExperienceObeliskEntity.this.setChanged();
        }

        public int getTanks() {
            return 1;
        }
    }
}

