/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.cognition.block_entities.bibliophage.agar;

import com.cyanogen.cognition.block.bibliophage.agar.FluorescentAgarBlock;
import com.cyanogen.cognition.block.bibliophage.agar.NutrientAgarBlock;
import com.cyanogen.cognition.registries.RegisterBlockEntities;
import com.cyanogen.cognition.registries.RegisterBlocks;
import com.cyanogen.cognition.registries.RegisterSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class FluorescentAgarEntity
extends BlockEntity {
    private int infectionProgress = 0;

    public FluorescentAgarEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)RegisterBlockEntities.FLUORESCENT_AGAR.get(), pos, state);
    }

    public void incrementInfectionProgress() {
        ++this.infectionProgress;
        BlockPos pos = this.getBlockPos();
        if (this.level != null) {
            this.level.levelEvent(null, 2001, pos, Block.getId((BlockState)((FluorescentAgarBlock)((Object)RegisterBlocks.FLUORESCENT_AGAR.get())).defaultBlockState()));
            if (this.infectionProgress >= 4) {
                this.level.playSound(null, pos, (SoundEvent)RegisterSounds.FLUORESCENT_AGAR_INFECT.get(), SoundSource.BLOCKS, 0.45f, 0.5f);
                this.level.setBlockAndUpdate(this.getBlockPos(), ((NutrientAgarBlock)((Object)RegisterBlocks.NUTRIENT_AGAR.get())).defaultBlockState());
            }
        }
        this.setChanged();
    }

    public int getInfectionProgress() {
        return this.infectionProgress;
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.infectionProgress = tag.getInt("InfectionProgress");
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putInt("InfectionProgress", this.infectionProgress);
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider provider) {
        super.handleUpdateTag(tag, provider);
        this.infectionProgress = tag.getInt("InfectionProgress");
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tag = super.getUpdateTag(provider);
        tag.putInt("InfectionProgress", this.infectionProgress);
        return tag;
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }
}

