/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.cognition.item;

import com.cyanogen.cognition.block_entities.ExperienceFountainEntity;
import com.cyanogen.cognition.block_entities.bibliophage.bookshelves.AbstractInfectedBookshelfEntity;
import com.cyanogen.cognition.config.Config;
import com.cyanogen.cognition.item.ActivatableItem;
import com.cyanogen.cognition.registries.RegisterSounds;
import com.cyanogen.cognition.utils.ExperienceUtils;
import com.cyanogen.cognition.utils.ItemUtils;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.fml.ModList;

public class EnlightenedAmuletItem
extends ActivatableItem {
    private final boolean clumpsIsLoaded = ModList.get().isLoaded("clumps");

    public EnlightenedAmuletItem(Item.Properties p) {
        super(p);
    }

    @Override
    public void playActivationSound(Player player) {
        player.playSound((SoundEvent)RegisterSounds.ENLIGHTENED_AMULET_ACTIVATE.get(), 0.2f, 1.0f);
    }

    @Override
    public void playDeactivationSound(Player player) {
        player.playSound((SoundEvent)RegisterSounds.ENLIGHTENED_AMULET_DEACTIVATE.get(), 0.2f, 0.8f);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slot, boolean isCurrentItem) {
        boolean isActive = ItemUtils.getCustomDataTag(stack).getBoolean("isActive");
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (isActive && !level.isClientSide && level.getGameTime() % 10L == 0L) {
                double radius = (Double)Config.COMMON.amuletRange.get();
                Vec3 pos = player.position();
                AABB area = new AABB(pos.x() - radius, pos.y() - radius, pos.z() - radius, pos.x() + radius, pos.y() + radius, pos.z() + radius);
                List list = level.getEntitiesOfClass(ExperienceOrb.class, area);
                int totalValue = 0;
                int valueLimit = 0x7FFFFFFE;
                int collectionLimit = 64;
                int collect = Math.min(collectionLimit, list.size());
                if (!list.isEmpty()) {
                    ExperienceOrb orb;
                    for (int i = 0; i < collect; ++i) {
                        int value;
                        boolean shouldCollect;
                        orb = (ExperienceOrb)list.get(i);
                        CompoundTag tag = new CompoundTag();
                        orb.addAdditionalSaveData(tag);
                        boolean spawnedFromFountain = orb.hasCustomName() && Objects.equals(orb.getCustomName(), ExperienceFountainEntity.FROM_FOUNTAIN);
                        boolean ignoreFountain = (Boolean)Config.COMMON.amuletIgnoresFountainOrbs.get();
                        boolean spawnedFromBookshelf = orb.hasCustomName() && Objects.equals(orb.getCustomName(), AbstractInfectedBookshelfEntity.FROM_BOOKSHELF);
                        boolean ignoreBookshelf = (Boolean)Config.COMMON.amuletIgnoresBookshelfOrbs.get();
                        boolean bl = shouldCollect = !(ignoreFountain && spawnedFromFountain || ignoreBookshelf && spawnedFromBookshelf);
                        if (!shouldCollect || orb.isRemoved()) continue;
                        int n = value = this.clumpsIsLoaded ? ExperienceUtils.getClumpedOrbValue(orb) : ExperienceUtils.getOrbValue(orb);
                        if (totalValue + value > valueLimit) break;
                        totalValue += value;
                        orb.discard();
                    }
                    ServerLevel server = (ServerLevel)level;
                    if (totalValue > 0) {
                        orb = new ExperienceOrb((Level)server, pos.x(), pos.y(), pos.z(), totalValue);
                        server.addFreshEntity((Entity)orb);
                    }
                    if (ItemUtils.getCustomName(stack).equals("Debug")) {
                        this.sendDebugMessage(player, collect, totalValue);
                    }
                }
            }
        }
        super.inventoryTick(stack, level, entity, slot, isCurrentItem);
    }

    public void sendDebugMessage(Player player, int orbsCollected, int totalValue) {
        player.sendSystemMessage((Component)Component.literal((String)("----- [Amulet] -----\nClumps installed: " + this.clumpsIsLoaded + "\n" + orbsCollected + " orbs collected with total value " + totalValue + " (" + ExperienceUtils.xpToLevels(totalValue) + " levels)\nPlayer levels: " + player.experienceLevel)));
    }
}

