/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.cognition.item;

import com.cyanogen.cognition.registries.RegisterSounds;
import com.cyanogen.cognition.utils.ExperienceUtils;
import com.cyanogen.cognition.utils.MiscUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class FlaskChaosItem
extends BucketItem {
    public static final int cost = 1;
    final int cooldown = 8;

    public FlaskChaosItem(Item.Properties p) {
        super(Fluids.EMPTY, p);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        BucketPickup bucketpickup;
        ItemStack test;
        BlockState blockState;
        Block block;
        ItemStack itemstack = player.getItemInHand(hand);
        BlockHitResult blockhitresult = FlaskChaosItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)(this.content == Fluids.EMPTY ? ClipContext.Fluid.SOURCE_ONLY : ClipContext.Fluid.NONE));
        if (blockhitresult.getType() == HitResult.Type.MISS) {
            return InteractionResultHolder.pass((Object)itemstack);
        }
        if (blockhitresult.getType() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.pass((Object)itemstack);
        }
        BlockPos blockpos = blockhitresult.getBlockPos();
        Direction direction = blockhitresult.getDirection();
        BlockPos blockpos1 = blockpos.relative(direction);
        if (level.mayInteract(player, blockpos) && player.mayUseItemAt(blockpos1, direction, itemstack) && this.canUse(player) && (block = (blockState = level.getBlockState(blockpos)).getBlock()) instanceof BucketPickup && !(test = (bucketpickup = (BucketPickup)block).pickupBlock(player, (LevelAccessor)level, blockpos, blockState)).isEmpty()) {
            this.handlePlayer(player);
            return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)level.isClientSide());
        }
        return InteractionResultHolder.fail((Object)itemstack);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Level level = context.getLevel();
        Player player = context.getPlayer();
        if (player != null && this.canUse(player)) {
            AbstractCauldronBlock block;
            BlockHitResult result = FlaskChaosItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
            BlockPos pos = result.getBlockPos();
            Direction direction = result.getDirection();
            BlockState state = level.getBlockState(pos);
            Block block2 = state.getBlock();
            if (block2 instanceof AbstractCauldronBlock && ((block = (AbstractCauldronBlock)block2).equals(Blocks.LAVA_CAULDRON) || block.equals(Blocks.WATER_CAULDRON))) {
                level.setBlockAndUpdate(pos, Blocks.CAULDRON.defaultBlockState());
                this.handlePlayer(player);
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (state.hasBlockEntity()) {
                int drainAmount;
                BlockEntity entity = level.getBlockEntity(pos);
                assert (entity != null);
                IFluidHandler handler = (IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, pos, (Object)direction);
                if (handler != null && (drainAmount = handler.drain(1000, IFluidHandler.FluidAction.SIMULATE).getAmount()) != 0) {
                    handler.drain(1000, IFluidHandler.FluidAction.EXECUTE);
                    this.handlePlayer(player);
                    return InteractionResult.sidedSuccess((boolean)level.isClientSide);
                }
            }
        }
        return super.onItemUseFirst(stack, context);
    }

    public boolean canUse(Player player) {
        return (player.isCreative() || ExperienceUtils.getTotalXP(player) >= 1L) && !player.getCooldowns().isOnCooldown((Item)this);
    }

    public void handlePlayer(Player player) {
        int k = player.isCreative() ? 0 : 1;
        player.getCooldowns().addCooldown((Item)this, 8);
        player.giveExperiencePoints(-1 * k);
        player.playSound((SoundEvent)RegisterSounds.FLASK_FILL_VOID.get(), MiscUtils.randomInRange(1.0f, 1.2f), MiscUtils.randomInRange(0.8f, 1.2f));
    }
}

