/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.cognition.loot_modifiers;

import com.cyanogen.cognition.utils.MiscUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.LootModifier;

public class AddSingleItem
extends LootModifier {
    public static final MapCodec<AddSingleItem> CODEC = RecordCodecBuilder.mapCodec(instance -> AddSingleItem.codecStart((RecordCodecBuilder.Instance)instance).and(instance.group((App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("id").forGetter(o -> o.item), (App)Codec.FLOAT.fieldOf("appear_chance").forGetter(o -> Float.valueOf(o.appearChance)), (App)Codec.INT.fieldOf("min_quantity").forGetter(o -> o.min), (App)Codec.INT.fieldOf("max_quantity").forGetter(o -> o.max), (App)Codec.FLOAT.fieldOf("bias").forGetter(o -> Float.valueOf(o.bias)), (App)Codec.STRING.fieldOf("path").forGetter(o -> o.path))).apply((Applicative)instance, AddSingleItem::new));
    public final Item item;
    public final float appearChance;
    public final int min;
    public final int max;
    public final float bias;
    public final String path;

    public AddSingleItem(LootItemCondition[] conditionsIn, Item item, float appearChance, int min, int max, float bias, String path) {
        super(conditionsIn);
        this.item = item;
        this.appearChance = appearChance;
        this.min = min;
        this.max = max;
        this.bias = bias;
        this.path = path;
    }

    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        String contextPath = context.getQueriedLootTableId().getPath();
        if (contextPath.contains(this.path) && Math.random() <= (double)this.appearChance) {
            int count = MiscUtils.weightedRandInt(this.min, this.max, this.bias);
            for (int i = 0; i < count; ++i) {
                generatedLoot.add((Object)new ItemStack((ItemLike)this.item, 1));
            }
            return generatedLoot;
        }
        return generatedLoot;
    }

    public MapCodec<AddSingleItem> codec() {
        return CODEC;
    }
}

