/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.cognition.recipe;

import com.cyanogen.cognition.registries.RegisterRecipes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class InfectingRecipe
implements Recipe<RecipeInput> {
    private final Ingredient ingredientBlock;
    private final ItemStack resultBlock;
    private final int infectionCount;
    private final ResourceLocation id;

    public InfectingRecipe(Ingredient inputBlock, ItemStack resultBlock, int infectionCount, ResourceLocation id) {
        this.ingredientBlock = inputBlock;
        this.resultBlock = resultBlock;
        this.infectionCount = infectionCount;
        this.id = id;
    }

    @Nullable
    public static InfectingRecipe getRecipe(Level level, Block ingredientBlock) {
        RecipeInput input = InfectingRecipe.recipeInput(ingredientBlock.asItem().getDefaultInstance());
        List recipeList = level.getRecipeManager().getAllRecipesFor((RecipeType)RegisterRecipes.INFECTING_TYPE.get());
        InfectingRecipe infectingRecipe = null;
        for (RecipeHolder holder : recipeList) {
            if (!((InfectingRecipe)holder.value()).matches(input)) continue;
            infectingRecipe = (InfectingRecipe)holder.value();
            break;
        }
        return infectingRecipe;
    }

    @Nullable
    public static BlockState getInfectedBlockState(Level level, BlockState ingredientBlockState) {
        ItemStack result;
        Item item;
        InfectingRecipe recipe = InfectingRecipe.getRecipe(level, ingredientBlockState.getBlock());
        if (recipe != null && (item = (result = recipe.assemble(ingredientBlockState.getBlock().asItem().getDefaultInstance(), (HolderLookup.Provider)level.registryAccess())).getItem()) instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            return blockItem.getBlock().defaultBlockState();
        }
        return null;
    }

    private static RecipeInput recipeInput(final ItemStack stack) {
        return new RecipeInput(){

            public ItemStack getItem(int i) {
                return stack;
            }

            public int size() {
                return 1;
            }
        };
    }

    public boolean matches(RecipeInput recipeInput) {
        return this.matches(recipeInput, null);
    }

    public boolean matches(RecipeInput recipeInput, @Nullable Level level) {
        return this.ingredientBlock.test(recipeInput.getItem(0));
    }

    public ItemStack assemble(ItemStack stack, HolderLookup.Provider provider) {
        return this.assemble(InfectingRecipe.recipeInput(stack), provider);
    }

    public ItemStack assemble(@Nullable RecipeInput recipeInput, @Nullable HolderLookup.Provider provider) {
        return this.resultBlock.copy();
    }

    public boolean canCraftInDimensions(int i, int i1) {
        return true;
    }

    public ItemStack getResultItem(@Nullable HolderLookup.Provider provider) {
        return this.resultBlock.copy();
    }

    public Ingredient getIngredient() {
        return this.ingredientBlock;
    }

    public int getInfectionCount() {
        return this.infectionCount;
    }

    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> getType() {
        return Type.INSTANCE;
    }

    public static class Serializer
    implements RecipeSerializer<InfectingRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"cognition", (String)"infecting");
        private static final MapCodec<InfectingRecipe> CODEC = RecordCodecBuilder.mapCodec(recipeInstance -> recipeInstance.group((App)Ingredient.CODEC.fieldOf("ingredient").forGetter(recipe -> recipe.ingredientBlock), (App)ItemStack.CODEC.fieldOf("result").forGetter(recipe -> recipe.resultBlock), (App)Codec.INT.fieldOf("infectionCount").forGetter(recipe -> recipe.infectionCount), (App)ResourceLocation.CODEC.fieldOf("id").forGetter(recipe -> recipe.id)).apply((Applicative)recipeInstance, InfectingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, InfectingRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public static InfectingRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            Ingredient inputBlock = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            ItemStack outputBlock = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            int infectionCount = buffer.readInt();
            ResourceLocation id = (ResourceLocation)ResourceLocation.STREAM_CODEC.decode((Object)buffer);
            return new InfectingRecipe(inputBlock, outputBlock, infectionCount, id);
        }

        public static void toNetwork(RegistryFriendlyByteBuf buffer, InfectingRecipe recipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.ingredientBlock);
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.resultBlock);
            buffer.writeInt(recipe.infectionCount);
            ResourceLocation.STREAM_CODEC.encode((Object)buffer, (Object)recipe.id);
        }

        public MapCodec<InfectingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, InfectingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }

    public static class Type
    implements RecipeType<InfectingRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "infecting";
    }
}

