/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin;

import com.mojang.logging.LogUtils;
import com.yanny.ali.api.IKeyTooltipNode;
import com.yanny.ali.api.ILootModifier;
import com.yanny.ali.api.IOperation;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.mixin.MixinLootModifier;
import com.yanny.ali.mixin.MixinLootTableIdCondition;
import com.yanny.ali.plugin.IForgeLootModifier;
import com.yanny.ali.plugin.IForgePlugin;
import com.yanny.ali.plugin.common.nodes.GlobalLootModifierNode;
import com.yanny.ali.plugin.common.tooltip.ArrayTooltipNode;
import com.yanny.ali.plugin.mods.BaseAccessor;
import com.yanny.ali.plugin.mods.ClassAccessor;
import com.yanny.ali.plugin.mods.ReflectionUtils;
import com.yanny.ali.plugin.server.GenericTooltipUtils;
import com.yanny.ali.plugin.server.TooltipUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntityTypePredicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.AnyOfCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import net.neoforged.neoforge.common.loot.LootTableIdCondition;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.slf4j.Logger;

public class GlobalLootModifierUtils {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static Optional<ILootModifier<?>> getLootModifier(final List<LootItemCondition> conditions, final Function<List<LootItemCondition>, List<IOperation>> operationSupplier) {
        if (GlobalLootModifierUtils.entityPredicate(conditions)) {
            return Optional.of(new ILootModifier<Entity>(){

                @Override
                public boolean predicate(Entity value) {
                    return GlobalLootModifierUtils.entityPredicate(conditions, value);
                }

                @Override
                public List<IOperation> getOperations() {
                    return (List)operationSupplier.apply(conditions.stream().filter(c -> !GlobalLootModifierUtils.entityPredicate(c)).toList());
                }

                @Override
                public ILootModifier.IType<Entity> getType() {
                    return ILootModifier.IType.ENTITY;
                }
            });
        }
        if (GlobalLootModifierUtils.blockPredicate(conditions)) {
            return Optional.of(new ILootModifier<Block>(){

                @Override
                public boolean predicate(Block value) {
                    return GlobalLootModifierUtils.blockPredicate(conditions, value);
                }

                @Override
                public List<IOperation> getOperations() {
                    return (List)operationSupplier.apply(conditions.stream().filter(c -> !GlobalLootModifierUtils.blockPredicate(c)).toList());
                }

                @Override
                public ILootModifier.IType<Block> getType() {
                    return ILootModifier.IType.BLOCK;
                }
            });
        }
        if (GlobalLootModifierUtils.tablePredicate(conditions)) {
            return Optional.of(new ILootModifier<ResourceLocation>(){

                @Override
                public boolean predicate(ResourceLocation value) {
                    return GlobalLootModifierUtils.tablePredicate(conditions, value);
                }

                @Override
                public List<IOperation> getOperations() {
                    return (List)operationSupplier.apply(conditions.stream().filter(c -> !GlobalLootModifierUtils.tablePredicate(c)).toList());
                }

                @Override
                public ILootModifier.IType<ResourceLocation> getType() {
                    return ILootModifier.IType.LOOT_TABLE;
                }
            });
        }
        return Optional.empty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean entityPredicate(LootItemCondition c) {
        LootItemEntityPropertyCondition condition;
        if (c instanceof LootItemEntityPropertyCondition && (condition = (LootItemEntityPropertyCondition)c).entityTarget() == LootContext.EntityTarget.THIS) {
            return true;
        }
        if (!(c instanceof AnyOfCondition)) return false;
        AnyOfCondition condition2 = (AnyOfCondition)c;
        if (!GlobalLootModifierUtils.entityPredicate(condition2.terms)) return false;
        return true;
    }

    public static boolean entityPredicate(List<LootItemCondition> conditions) {
        return conditions.stream().anyMatch(GlobalLootModifierUtils::entityPredicate);
    }

    public static boolean entityPredicate(List<LootItemCondition> conditions, Entity entity) {
        return conditions.stream().anyMatch(c -> {
            LootItemEntityPropertyCondition condition;
            if (c instanceof LootItemEntityPropertyCondition && (condition = (LootItemEntityPropertyCondition)c).entityTarget() == LootContext.EntityTarget.THIS && condition.predicate().isPresent() && ((EntityPredicate)condition.predicate().get()).entityType().isPresent() && ((EntityTypePredicate)((EntityPredicate)condition.predicate().get()).entityType().get()).matches(entity.getType())) {
                return true;
            }
            if (!(c instanceof AnyOfCondition)) return false;
            AnyOfCondition condition2 = (AnyOfCondition)c;
            if (!GlobalLootModifierUtils.entityPredicate(condition2.terms, entity)) return false;
            return true;
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean blockPredicate(LootItemCondition c) {
        if (c instanceof LootItemBlockStatePropertyCondition) {
            return true;
        }
        if (!(c instanceof AnyOfCondition)) return false;
        AnyOfCondition condition = (AnyOfCondition)c;
        if (!GlobalLootModifierUtils.blockPredicate(condition.terms)) return false;
        return true;
    }

    public static boolean blockPredicate(List<LootItemCondition> conditions) {
        return conditions.stream().anyMatch(GlobalLootModifierUtils::blockPredicate);
    }

    public static boolean blockPredicate(List<LootItemCondition> conditions, Block block) {
        return conditions.stream().anyMatch(c -> {
            LootItemBlockStatePropertyCondition condition;
            if (c instanceof LootItemBlockStatePropertyCondition && (condition = (LootItemBlockStatePropertyCondition)c).block().equals((Object)block)) {
                return true;
            }
            if (!(c instanceof AnyOfCondition)) return false;
            AnyOfCondition condition2 = (AnyOfCondition)c;
            if (!GlobalLootModifierUtils.blockPredicate(condition2.terms, block)) return false;
            return true;
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean tablePredicate(LootItemCondition c) {
        if (c instanceof LootTableIdCondition) {
            return true;
        }
        if (!(c instanceof AnyOfCondition)) return false;
        AnyOfCondition condition = (AnyOfCondition)c;
        if (!GlobalLootModifierUtils.tablePredicate(condition.terms)) return false;
        return true;
    }

    public static boolean tablePredicate(List<LootItemCondition> conditions) {
        return conditions.stream().anyMatch(GlobalLootModifierUtils::tablePredicate);
    }

    public static boolean tablePredicate(List<LootItemCondition> conditions, ResourceLocation location) {
        return conditions.stream().anyMatch(c -> {
            LootTableIdCondition condition;
            if (c instanceof LootTableIdCondition && ((MixinLootTableIdCondition)(condition = (LootTableIdCondition)c)).getTargetLootTableId().equals((Object)location)) {
                return true;
            }
            if (!(c instanceof AnyOfCondition)) return false;
            AnyOfCondition condition2 = (AnyOfCondition)c;
            if (!GlobalLootModifierUtils.tablePredicate(condition2.terms, location)) return false;
            return true;
        });
    }

    public static <T extends BaseAccessor<?>> void registerGlobalLootModifier(IForgePlugin.IRegistry registry, Class<T> clazz) {
        ClassAccessor classAnnotation = clazz.getAnnotation(ClassAccessor.class);
        if (classAnnotation != null) {
            try {
                Class<?> functionClass = Class.forName(classAnnotation.value());
                registry.registerGlobalLootModifier(functionClass, (u, c) -> ((IForgeLootModifier)ReflectionUtils.copyClassData(clazz, c)).getLootModifier((IServerUtils)u));
            }
            catch (Throwable e) {
                LOGGER.warn("Failed to register GLM for {} with error {}", (Object)classAnnotation.value(), (Object)e.getMessage());
                e.printStackTrace();
            }
        } else {
            throw new IllegalStateException("Missing ClassAccessor annotation for GLM " + clazz.getName());
        }
    }

    public static Optional<ILootModifier<?>> getMissingGlobalLootModifier(IServerUtils utils, IGlobalLootModifier modifier) {
        if (modifier instanceof LootModifier) {
            LootModifier lootModifier = (LootModifier)modifier;
            return GlobalLootModifierUtils.getLootModifier(Arrays.asList(((MixinLootModifier)lootModifier).getConditions()), conditions -> {
                ArrayTooltipNode.Builder tooltip = ArrayTooltipNode.array();
                IKeyTooltipNode fieldsTooltip = utils.getValueTooltip(utils, GlobalLootModifierUtils.getName(modifier));
                TooltipUtils.addObjectFields(utils, fieldsTooltip, lootModifier, LootModifier.class);
                tooltip.add(fieldsTooltip.build("ali.util.advanced_loot_info.auto_detected"));
                tooltip.add(GenericTooltipUtils.getConditionsTooltip(utils, conditions));
                return List.of(new IOperation.AddOperation(i -> true, new GlobalLootModifierNode(utils, tooltip.build())));
            });
        }
        return Optional.empty();
    }

    public static ResourceLocation getName(IGlobalLootModifier modifier) {
        return NeoForgeRegistries.GLOBAL_LOOT_MODIFIER_SERIALIZERS.getKey((Object)modifier.codec());
    }
}

