/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.lootjs.server;

import com.almostreliable.lootjs.core.filters.IdFilter;
import com.almostreliable.lootjs.core.filters.ItemFilter;
import com.almostreliable.lootjs.core.filters.ItemFilterImpl;
import com.yanny.ali.api.IKeyTooltipNode;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.plugin.common.tooltip.BranchTooltipNode;
import com.yanny.ali.plugin.common.tooltip.ValueTooltipNode;
import com.yanny.ali.plugin.server.GenericTooltipUtils;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.common.ItemAbility;
import org.jetbrains.annotations.NotNull;

public class LootJsGenericTooltipUtils {
    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static IKeyTooltipNode getItemFilterTooltip(IServerUtils utils, ItemFilter predicate) {
        if (predicate == ItemFilter.NONE) {
            return ValueTooltipNode.value("NONE");
        }
        if (predicate == ItemFilter.ANY) {
            return ValueTooltipNode.value("ANY");
        }
        if (predicate == ItemFilter.EMPTY) {
            return ValueTooltipNode.value("EMPTY");
        }
        if (predicate == ItemFilter.ARMOR) {
            return ValueTooltipNode.value("ARMOR");
        }
        if (predicate == ItemFilter.EDIBLE) {
            return ValueTooltipNode.value("EDIBLE");
        }
        if (predicate == ItemFilter.DAMAGEABLE) {
            return ValueTooltipNode.value("DAMAGEABLE");
        }
        if (predicate == ItemFilter.DAMAGED) {
            return ValueTooltipNode.value("ENCHANTABLE");
        }
        if (predicate == ItemFilter.ENCHANTED) {
            return ValueTooltipNode.value("ENCHANTED");
        }
        if (predicate == ItemFilter.BLOCK_ITEM) {
            return ValueTooltipNode.value("BLOCK_ITEM");
        }
        if (predicate instanceof ItemFilterImpl.HasEnchantment) {
            ItemFilterImpl.HasEnchantment hasEnchantment = (ItemFilterImpl.HasEnchantment)predicate;
            try {
                IdFilter idFilter;
                IdFilter filter = idFilter = hasEnchantment.filter();
                IdFilter levelBounds = idFilter = hasEnchantment.levelBounds();
                IdFilter type = idFilter = hasEnchantment.type();
                return ValueTooltipNode.value("HAS_ENCHANTMENT").add(utils.getValueTooltip(utils, filter).build("ali.property.branch.filter")).add(utils.getValueTooltip(utils, levelBounds).build("ali.property.value.levels")).add(utils.getValueTooltip(utils, type).build("ali.property.value.component"));
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
        }
        if (predicate instanceof ItemFilterImpl.IsEquipmentSlot) {
            EquipmentSlot equipmentSlot2;
            ItemFilterImpl.IsEquipmentSlot isEquipmentSlot = (ItemFilterImpl.IsEquipmentSlot)predicate;
            {
                EquipmentSlot equipmentSlot;
                equipmentSlot2 = equipmentSlot = isEquipmentSlot.equipmentSlot();
            }
            return ValueTooltipNode.value("EQUIPMENT_SLOT").add(utils.getValueTooltip(utils, equipmentSlot2).build("ali.property.value.slot"));
        }
        if (predicate instanceof ItemFilterImpl.IsEquipmentSlotGroup) {
            EquipmentSlotGroup equipmentSlotGroup2;
            ItemFilterImpl.IsEquipmentSlotGroup isEquipmentSlotGroup = (ItemFilterImpl.IsEquipmentSlotGroup)predicate;
            {
                EquipmentSlotGroup equipmentSlotGroup;
                equipmentSlotGroup2 = equipmentSlotGroup = isEquipmentSlotGroup.equipmentSlotGroup();
            }
            return ValueTooltipNode.value("EQUIPMENT_SLOT_GROUP").add(utils.getValueTooltip(utils, equipmentSlotGroup2).build("ali.property.value.slot_group"));
        }
        if (predicate instanceof ItemFilterImpl.ByItem) {
            boolean checkComponents;
            ItemStack itemStack2;
            ItemFilterImpl.ByItem byItem = (ItemFilterImpl.ByItem)predicate;
            {
                boolean bl;
                ItemStack itemStack;
                itemStack2 = itemStack = byItem.filter();
                checkComponents = bl = byItem.checkComponents();
            }
            return ValueTooltipNode.value("ITEM").add(utils.getValueTooltip(utils, itemStack2).build("ali.property.branch.item")).add(utils.getValueTooltip(utils, checkComponents).build("ali.property.value.check_components"));
        }
        if (predicate instanceof ItemFilterImpl.ByIngredient) {
            Ingredient ingredient2;
            ItemFilterImpl.ByIngredient byIngredient = (ItemFilterImpl.ByIngredient)predicate;
            {
                Ingredient ingredient;
                ingredient2 = ingredient = byIngredient.ingredient();
            }
            return ValueTooltipNode.value("INGREDIENT").add(utils.getIngredientTooltip(utils, ingredient2));
        }
        if (predicate instanceof ItemFilterImpl.ByTag) {
            TagKey tag;
            ItemFilterImpl.ByTag byTag = (ItemFilterImpl.ByTag)predicate;
            {
                TagKey tagKey;
                tag = tagKey = byTag.tag();
            }
            return ValueTooltipNode.value("TAG").add(utils.getValueTooltip(utils, tag).build("ali.property.value.null"));
        }
        if (predicate instanceof ItemFilterImpl.AnyOfToolAction) {
            ItemFilterImpl.AnyOfToolAction toolAction = (ItemFilterImpl.AnyOfToolAction)predicate;
            return ValueTooltipNode.value("ANY_OF_TOOL_ACTION").add(utils.getValueTooltip(utils, toolAction.toolActions()).build("ali.property.branch.abilities"));
        }
        if (predicate instanceof ItemFilterImpl.AllOfToolAction) {
            ItemFilterImpl.AllOfToolAction toolAction = (ItemFilterImpl.AllOfToolAction)predicate;
            return ValueTooltipNode.value("ALL_OF_TOOL_ACTION").add(utils.getValueTooltip(utils, toolAction.toolActions()).build("ali.property.branch.abilities"));
        }
        if (predicate instanceof ItemFilterImpl.Not) {
            ItemFilter itemFilter2;
            ItemFilterImpl.Not not = (ItemFilterImpl.Not)predicate;
            {
                ItemFilter itemFilter;
                itemFilter2 = itemFilter = not.itemFilter();
            }
            return ValueTooltipNode.value("NOT").add(utils.getValueTooltip(utils, itemFilter2).build("ali.property.branch.filter"));
        }
        if (predicate instanceof ItemFilterImpl.AllOf) {
            ItemFilterImpl.AllOf allOf = (ItemFilterImpl.AllOf)predicate;
            return ValueTooltipNode.value("ALL_OF").add(GenericTooltipUtils.getCollectionTooltip(utils, "ali.property.value.filter", Arrays.asList(allOf.itemFilters())).build("ali.property.branch.filters"));
        }
        if (predicate instanceof ItemFilterImpl.AnyOf) {
            ItemFilterImpl.AnyOf allOf = (ItemFilterImpl.AnyOf)predicate;
            return ValueTooltipNode.value("ANY_OF").add(GenericTooltipUtils.getCollectionTooltip(utils, "ali.property.value.filter", Arrays.asList(allOf.itemFilters())).build("ali.property.branch.filters"));
        }
        if (!(predicate instanceof ItemFilterImpl.Custom)) return ValueTooltipNode.value("UNKNOWN");
        ItemFilterImpl.Custom custom = (ItemFilterImpl.Custom)predicate;
        return ValueTooltipNode.value("CUSTOM").add(utils.getValueTooltip(utils, Optional.ofNullable(custom.description())).build("ali.property.value.description"));
    }

    @NotNull
    public static IKeyTooltipNode getIdFilterTooltip(IServerUtils utils, IdFilter filter) {
        BranchTooltipNode.Builder tooltip = BranchTooltipNode.branch();
        IdFilter idFilter = filter;
        Objects.requireNonNull(idFilter);
        IdFilter idFilter2 = idFilter;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IdFilter.ByLocation.class, IdFilter.ByPattern.class, IdFilter.ByMod.class, IdFilter.Or.class}, (Object)idFilter2, n)) {
            case 0: {
                IdFilter.ByLocation byLocation = (IdFilter.ByLocation)idFilter2;
                tooltip.add(utils.getValueTooltip(utils, byLocation.location()).build("ali.property.value.null"));
                break;
            }
            case 1: {
                IdFilter.ByPattern byPattern = (IdFilter.ByPattern)idFilter2;
                tooltip.add(utils.getValueTooltip(utils, byPattern.toString()).build("ali.property.value.pattern"));
                break;
            }
            case 2: {
                IdFilter.ByMod byMod = (IdFilter.ByMod)idFilter2;
                tooltip.add(utils.getValueTooltip(utils, byMod.mod()).build("ali.property.value.mod"));
                break;
            }
            case 3: {
                IdFilter.Or or = (IdFilter.Or)idFilter2;
                tooltip.add(utils.getValueTooltip(utils, or.filters()).build("ali.property.branch.or"));
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected IdFilter type: " + String.valueOf(filter));
            }
        }
        return tooltip;
    }

    @NotNull
    public static IKeyTooltipNode getItemAbilityTooltip(IServerUtils utils, ItemAbility itemAbility) {
        return utils.getValueTooltip(utils, itemAbility.name());
    }
}

