/*
 * Decompiled with CFR 0.152.
 */
package artifacts.loot;

import artifacts.Artifacts;
import artifacts.config.value.Value;
import artifacts.config.value.ValueTypes;
import artifacts.registry.ModLootConditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public class ConfigValueCondition
implements LootItemCondition {
    public static final MapCodec<ConfigValueCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ValueTypes.BOOLEAN.codec().fieldOf("value").forGetter(ConfigValueCondition::value)).apply((Applicative)instance, ConfigValueCondition::new));
    private final Value<Boolean> value;

    protected ConfigValueCondition(Value<Boolean> value) {
        this.value = value;
    }

    protected Value<Boolean> value() {
        return this.value;
    }

    public LootItemConditionType getType() {
        return (LootItemConditionType)ModLootConditions.CONFIG_VALUE.value();
    }

    public boolean test(LootContext lootContext) {
        return (Boolean)this.value.get();
    }

    public static LootItemCondition.Builder canGenerateAsLoot(Item item) {
        Value<Boolean> generatesAsLoot = Artifacts.CONFIG.items.generatesAsLoot(item);
        if (generatesAsLoot == null) {
            throw new IllegalArgumentException();
        }
        return () -> new ConfigValueCondition(generatesAsLoot);
    }
}

