/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.prism;

import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.DirectionAxis;

public class FramedElevatedInnerPrismGeometry
extends Geometry {
    private final Direction facing;
    private final Direction.Axis axis;
    private final boolean ySlope;

    public FramedElevatedInnerPrismGeometry(GeometryFactory.Context ctx) {
        DirectionAxis dirAxis = (DirectionAxis)((Object)ctx.state().getValue(PropertyHolder.FACING_AXIS));
        this.facing = dirAxis.direction();
        this.axis = dirAxis.axis();
        this.ySlope = (Boolean)ctx.state().getValue((Property)FramedProperties.Y_SLOPE);
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        boolean quadOnAxis;
        boolean yFacing = Utils.isY(this.facing);
        boolean yAxis = this.axis == Direction.Axis.Y;
        Direction quadFace = quad.getDirection();
        boolean quadOnFacingAxis = quadFace.getAxis() == this.facing.getAxis();
        boolean bl = quadOnAxis = quadFace.getAxis() == this.axis;
        if (!this.ySlope && yFacing && !quadOnAxis && !quadOnFacingAxis) {
            boolean up = this.facing == Direction.UP;
            QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(up, 0.5f)).apply(Modifiers.makeVerticalSlope(up, 45.0f)).export(quadMap.get(null));
        } else if (this.ySlope && yFacing && quadFace == this.facing) {
            Direction onAxis = Direction.fromAxisAndDirection((Direction.Axis)this.axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
            Direction offAxisCW = onAxis.getClockWise();
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(offAxisCW, 0.5f)).apply(Modifiers.makeVerticalSlope(offAxisCW, 45.0f)).export(quadMap.get(null));
            Direction offAxisCCW = onAxis.getCounterClockWise();
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(offAxisCCW, 0.5f)).apply(Modifiers.makeVerticalSlope(offAxisCCW, 45.0f)).export(quadMap.get(null));
        } else if (!yFacing && yAxis && !quadOnAxis && quadOnFacingAxis) {
            QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(this.facing.getClockWise(), 0.5f)).apply(Modifiers.makeHorizontalSlope(true, 45.0f)).export(quadMap.get(null));
            QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(this.facing.getCounterClockWise(), 0.5f)).apply(Modifiers.makeHorizontalSlope(false, 45.0f)).export(quadMap.get(null));
        } else if (!(this.ySlope || yFacing || yAxis || quadFace != this.facing)) {
            QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(false, 0.5f)).apply(Modifiers.makeVerticalSlope(true, 45.0f)).export(quadMap.get(null));
            QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(true, 0.5f)).apply(Modifiers.makeVerticalSlope(false, 45.0f)).export(quadMap.get(null));
        } else if (this.ySlope && !yFacing && !yAxis && Utils.isY(quadFace)) {
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.facing.getOpposite(), 0.5f)).apply(Modifiers.makeVerticalSlope(this.facing, 45.0f)).export(quadMap.get(null));
        } else if (quadOnAxis) {
            if (yAxis) {
                QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.facing.getClockWise(), 0.5f)).apply(Modifiers.cutTopBottom(this.facing, 0.0f, 1.0f)).export(quadMap.get(quadFace));
                QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.facing.getCounterClockWise(), 0.5f)).apply(Modifiers.cutTopBottom(this.facing, 1.0f, 0.0f)).export(quadMap.get(quadFace));
            } else if (yFacing) {
                QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(quadFace.getClockWise(), 0.5f)).apply(Modifiers.cutSideUpDown(this.facing == Direction.DOWN, 0.0f, 1.0f)).export(quadMap.get(quadFace));
                QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(quadFace.getCounterClockWise(), 0.5f)).apply(Modifiers.cutSideUpDown(this.facing == Direction.DOWN, 1.0f, 0.0f)).export(quadMap.get(quadFace));
            } else {
                QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(true, 0.5f)).apply(Modifiers.cutSideLeftRight(this.facing, 1.0f, 0.0f)).export(quadMap.get(quadFace));
                QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(false, 0.5f)).apply(Modifiers.cutSideLeftRight(this.facing, 0.0f, 1.0f)).export(quadMap.get(quadFace));
            }
        }
    }

    @Override
    public boolean transformAllQuads() {
        if (this.ySlope) {
            return true;
        }
        return Utils.isY(this.facing) || this.axis == Direction.Axis.Y;
    }
}

