/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.slope;

import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.common.data.PropertyHolder;

public class FramedHalfSlopeGeometry
extends Geometry {
    private final Direction dir;
    private final boolean top;
    private final boolean right;
    private final boolean ySlope;

    public FramedHalfSlopeGeometry(GeometryFactory.Context ctx) {
        this.dir = (Direction)ctx.state().getValue((Property)FramedProperties.FACING_HOR);
        this.top = (Boolean)ctx.state().getValue((Property)FramedProperties.TOP);
        this.right = (Boolean)ctx.state().getValue((Property)PropertyHolder.RIGHT);
        this.ySlope = (Boolean)ctx.state().getValue((Property)FramedProperties.Y_SLOPE);
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        Direction cutDir;
        Direction quadDir = quad.getDirection();
        Direction direction = cutDir = this.right ? this.dir.getCounterClockWise() : this.dir.getClockWise();
        if (!this.ySlope && quadDir == this.dir.getOpposite()) {
            QuadModifier.of(quad).apply(Modifiers.makeVerticalSlope(!this.top, 45.0f)).apply(Modifiers.cutSideLeftRight(cutDir, 0.5f)).export(quadMap.get(null));
        } else if (this.ySlope && (!this.top && quadDir == Direction.UP || this.top && quadDir == Direction.DOWN)) {
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(cutDir, 0.5f)).apply(Modifiers.makeVerticalSlope(this.dir.getOpposite(), 45.0f)).export(quadMap.get(null));
        } else if (quadDir == this.dir.getClockWise() || quadDir == this.dir.getCounterClockWise()) {
            boolean needOffset = this.right == (quadDir == this.dir.getCounterClockWise());
            QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(this.dir.getOpposite(), this.top ? 1.0f : 0.0f, this.top ? 0.0f : 1.0f)).applyIf(Modifiers.setPosition(0.5f), needOffset).export(quadMap.get(needOffset ? null : quadDir));
        } else if (!this.top && quadDir == Direction.DOWN || this.top && quadDir == Direction.UP) {
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(cutDir, 0.5f)).export(quadMap.get(quadDir));
        } else if (quadDir == this.dir) {
            QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(cutDir, 0.5f)).export(quadMap.get(quadDir));
        }
    }
}

