/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.blockentity.doubled.slope;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.blockentity.doubled.FramedDoubleBlockEntity;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.SlopeType;

public class FramedDoubleSlopeBlockEntity
extends FramedDoubleBlockEntity {
    public FramedDoubleSlopeBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FBContent.BE_TYPE_DOUBLE_FRAMED_SLOPE.value(), pos, state);
    }

    @Override
    protected boolean hitSecondary(BlockHitResult hit, Vec3 lookVec, Vec3 eyePos) {
        double hor;
        SlopeType type = (SlopeType)((Object)this.getBlockState().getValue(PropertyHolder.SLOPE_TYPE));
        Direction facing = (Direction)this.getBlockState().getValue((Property)FramedProperties.FACING_HOR);
        Direction side = hit.getDirection();
        Vec3 vec = Utils.fraction(hit.getLocation());
        if (type == SlopeType.HORIZONTAL) {
            boolean secondary;
            if (side == facing || side == facing.getCounterClockWise()) {
                return false;
            }
            if (side == facing.getOpposite() || side == facing.getClockWise()) {
                return true;
            }
            boolean bl = Utils.isX(facing) ? vec.x() >= vec.z() : (secondary = vec.z() >= 1.0 - vec.x());
            if (Utils.isPositive(facing)) {
                secondary = !secondary;
            }
            return secondary;
        }
        double d = hor = Utils.isX(facing) ? vec.x() : vec.z();
        if (!Utils.isPositive(facing)) {
            hor = 1.0 - hor;
        }
        if (type == SlopeType.TOP) {
            if (side == facing || side == Direction.UP) {
                return false;
            }
            if (side == facing.getOpposite() || side == Direction.DOWN) {
                return true;
            }
            return vec.y() <= 1.0 - hor;
        }
        if (type == SlopeType.BOTTOM) {
            if (side == facing || side == Direction.DOWN) {
                return false;
            }
            if (side == facing.getOpposite() || side == Direction.UP) {
                return true;
            }
            return vec.y() >= hor;
        }
        return false;
    }
}

