/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.analysis.morph;

import guideme.internal.shaded.lucene.analysis.morph.CharacterDefinition;
import guideme.internal.shaded.lucene.codecs.CodecUtil;
import guideme.internal.shaded.lucene.store.DataOutput;
import guideme.internal.shaded.lucene.store.OutputStreamDataOutput;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;

public final class CharacterDefinitionWriter<T extends CharacterDefinition> {
    private final Class<T> implClazz;
    private final byte[] characterCategoryMap = new byte[65536];
    private final int classCount;
    private final boolean[] invokeMap;
    private final boolean[] groupMap;
    private final CharacterDefinition.LookupCharacterClass lookupCharClass;

    public CharacterDefinitionWriter(Class<T> implClazz, byte defaultValue, int classCount, CharacterDefinition.LookupCharacterClass lookupCharClass) {
        this.implClazz = implClazz;
        Arrays.fill(this.characterCategoryMap, defaultValue);
        this.invokeMap = new boolean[classCount];
        this.groupMap = new boolean[classCount];
        this.classCount = classCount;
        this.lookupCharClass = lookupCharClass;
    }

    public void putCharacterCategory(int codePoint, String characterClassName) {
        characterClassName = characterClassName.split(" ")[0];
        if (codePoint == 12539) {
            characterClassName = "SYMBOL";
        }
        this.characterCategoryMap[codePoint] = this.lookupCharClass.lookupCharacterClass(characterClassName);
    }

    public void putInvokeDefinition(String characterClassName, int invoke, int group, int length) {
        byte characterClass = this.lookupCharClass.lookupCharacterClass(characterClassName);
        this.invokeMap[characterClass] = invoke == 1;
        this.groupMap[characterClass] = group == 1;
    }

    private String getBaseFileName() {
        return this.implClazz.getName().replace('.', '/');
    }

    public void write(Path baseDir, String charDefCodecHeader, int charDefCodecVersion) throws IOException {
        Path path = baseDir.resolve(this.getBaseFileName() + ".dat");
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        try (BufferedOutputStream os = new BufferedOutputStream(Files.newOutputStream(path, new OpenOption[0]));){
            OutputStreamDataOutput out = new OutputStreamDataOutput(os);
            CodecUtil.writeHeader(out, charDefCodecHeader, charDefCodecVersion);
            ((DataOutput)out).writeBytes(this.characterCategoryMap, 0, this.characterCategoryMap.length);
            for (int i = 0; i < this.classCount; ++i) {
                byte b = (byte)((this.invokeMap[i] ? 1 : 0) | (this.groupMap[i] ? 2 : 0));
                ((DataOutput)out).writeByte(b);
            }
        }
    }
}

