/*
 * Decompiled with CFR 0.152.
 */
package guideme.scene.element;

import guideme.compiler.PageCompiler;
import guideme.compiler.tags.MdxAttrs;
import guideme.document.LytErrorSink;
import guideme.libs.mdast.mdx.model.MdxJsxElementFields;
import guideme.scene.GuidebookScene;
import guideme.scene.element.SceneElementTagCompiler;
import guideme.scene.level.GuidebookLevel;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class SceneRemoveBlocksElementCompiler
implements SceneElementTagCompiler {
    @Override
    public Set<String> getTagNames() {
        return Set.of("RemoveBlocks");
    }

    @Override
    public void compile(GuidebookScene scene, PageCompiler compiler, LytErrorSink errorSink, MdxJsxElementFields el) {
        Predicate<BlockState> predicate = MdxAttrs.getRequiredBlockStatePredicate(compiler, errorSink, el, "id");
        if (predicate == null) {
            return;
        }
        GuidebookLevel level = scene.getLevel();
        Iterator it = level.getFilledBlocks().iterator();
        while (it.hasNext()) {
            BlockPos pos = (BlockPos)it.next();
            if (!predicate.test(level.getBlockState(pos))) continue;
            level.setBlock(pos, Blocks.AIR.defaultBlockState(), 0);
        }
    }
}

