/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.lib.bytesocks.ws;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import me.lucko.spark.lib.bytesocks.ws.WebSocket;
import me.lucko.spark.lib.bytesocks.ws.drafts.Draft;
import me.lucko.spark.lib.bytesocks.ws.exceptions.InvalidDataException;
import me.lucko.spark.lib.bytesocks.ws.framing.Framedata;
import me.lucko.spark.lib.bytesocks.ws.framing.PingFrame;
import me.lucko.spark.lib.bytesocks.ws.handshake.ClientHandshake;
import me.lucko.spark.lib.bytesocks.ws.handshake.Handshakedata;
import me.lucko.spark.lib.bytesocks.ws.handshake.ServerHandshake;
import me.lucko.spark.lib.bytesocks.ws.handshake.ServerHandshakeBuilder;

public interface WebSocketListener {
    public ServerHandshakeBuilder onWebsocketHandshakeReceivedAsServer(WebSocket var1, Draft var2, ClientHandshake var3) throws InvalidDataException;

    public void onWebsocketHandshakeReceivedAsClient(WebSocket var1, ClientHandshake var2, ServerHandshake var3) throws InvalidDataException;

    public void onWebsocketHandshakeSentAsClient(WebSocket var1, ClientHandshake var2) throws InvalidDataException;

    public void onWebsocketMessage(WebSocket var1, String var2);

    public void onWebsocketMessage(WebSocket var1, ByteBuffer var2);

    public void onWebsocketOpen(WebSocket var1, Handshakedata var2);

    public void onWebsocketClose(WebSocket var1, int var2, String var3, boolean var4);

    public void onWebsocketClosing(WebSocket var1, int var2, String var3, boolean var4);

    public void onWebsocketCloseInitiated(WebSocket var1, int var2, String var3);

    public void onWebsocketError(WebSocket var1, Exception var2);

    public void onWebsocketPing(WebSocket var1, Framedata var2);

    public PingFrame onPreparePing(WebSocket var1);

    public void onWebsocketPong(WebSocket var1, Framedata var2);

    public void onWriteDemand(WebSocket var1);

    public InetSocketAddress getLocalSocketAddress(WebSocket var1);

    public InetSocketAddress getRemoteSocketAddress(WebSocket var1);
}

