/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens;

import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.screens.PresetFlatWorldScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.flat.FlatLayerInfo;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorSettings;

public class CreateFlatWorldScreen
extends Screen {
    static final ResourceLocation SLOT_SPRITE = ResourceLocation.withDefaultNamespace("container/slot");
    private static final int SLOT_BG_SIZE = 18;
    private static final int SLOT_STAT_HEIGHT = 20;
    private static final int SLOT_BG_X = 1;
    private static final int SLOT_BG_Y = 1;
    private static final int SLOT_FG_X = 2;
    private static final int SLOT_FG_Y = 2;
    protected final CreateWorldScreen parent;
    private final Consumer<FlatLevelGeneratorSettings> applySettings;
    FlatLevelGeneratorSettings generator;
    private Component columnType;
    private Component columnHeight;
    private DetailsList list;
    private Button deleteLayerButton;

    public CreateFlatWorldScreen(CreateWorldScreen p_95822_, Consumer<FlatLevelGeneratorSettings> p_95823_, FlatLevelGeneratorSettings p_95824_) {
        super(Component.translatable("createWorld.customize.flat.title"));
        this.parent = p_95822_;
        this.applySettings = p_95823_;
        this.generator = p_95824_;
    }

    public FlatLevelGeneratorSettings settings() {
        return this.generator;
    }

    public void setConfig(FlatLevelGeneratorSettings p_95826_) {
        this.generator = p_95826_;
    }

    @Override
    protected void init() {
        this.columnType = Component.translatable("createWorld.customize.flat.tile");
        this.columnHeight = Component.translatable("createWorld.customize.flat.height");
        this.list = this.addRenderableWidget(new DetailsList());
        this.deleteLayerButton = this.addRenderableWidget(Button.builder(Component.translatable("createWorld.customize.flat.removeLayer"), p_95845_ -> {
            if (!this.hasValidSelection()) {
                return;
            }
            List<FlatLayerInfo> $$1 = this.generator.getLayersInfo();
            int $$2 = this.list.children().indexOf(this.list.getSelected());
            int $$3 = $$1.size() - $$2 - 1;
            $$1.remove($$3);
            this.list.setSelected($$1.isEmpty() ? null : (DetailsList.Entry)this.list.children().get(Math.min($$2, $$1.size() - 1)));
            this.generator.updateLayers();
            this.list.resetRows();
            this.updateButtonValidity();
        }).bounds(this.width / 2 - 155, this.height - 52, 150, 20).build());
        this.addRenderableWidget(Button.builder(Component.translatable("createWorld.customize.presets"), p_280790_ -> {
            this.minecraft.setScreen(new PresetFlatWorldScreen(this));
            this.generator.updateLayers();
            this.updateButtonValidity();
        }).bounds(this.width / 2 + 5, this.height - 52, 150, 20).build());
        this.addRenderableWidget(Button.builder(CommonComponents.GUI_DONE, p_280791_ -> {
            this.applySettings.accept(this.generator);
            this.minecraft.setScreen(this.parent);
            this.generator.updateLayers();
        }).bounds(this.width / 2 - 155, this.height - 28, 150, 20).build());
        this.addRenderableWidget(Button.builder(CommonComponents.GUI_CANCEL, p_280792_ -> {
            this.minecraft.setScreen(this.parent);
            this.generator.updateLayers();
        }).bounds(this.width / 2 + 5, this.height - 28, 150, 20).build());
        this.generator.updateLayers();
        this.updateButtonValidity();
    }

    void updateButtonValidity() {
        this.deleteLayerButton.active = this.hasValidSelection();
    }

    private boolean hasValidSelection() {
        return this.list.getSelected() != null;
    }

    @Override
    public void onClose() {
        this.minecraft.setScreen(this.parent);
    }

    @Override
    public void render(GuiGraphics p_282393_, int p_95829_, int p_95830_, float p_95831_) {
        super.render(p_282393_, p_95829_, p_95830_, p_95831_);
        p_282393_.drawCenteredString(this.font, this.title, this.width / 2, 8, 0xFFFFFF);
        int $$4 = this.width / 2 - 92 - 16;
        p_282393_.drawString(this.font, this.columnType, $$4, 32, 0xFFFFFF);
        p_282393_.drawString(this.font, this.columnHeight, $$4 + 2 + 213 - this.font.width(this.columnHeight), 32, 0xFFFFFF);
    }

    class DetailsList
    extends ObjectSelectionList<Entry> {
        public DetailsList() {
            super(CreateFlatWorldScreen.this.minecraft, CreateFlatWorldScreen.this.width, CreateFlatWorldScreen.this.height - 103, 43, 24);
            for (int $$0 = 0; $$0 < CreateFlatWorldScreen.this.generator.getLayersInfo().size(); ++$$0) {
                this.addEntry(new Entry());
            }
        }

        @Override
        public void setSelected(@Nullable Entry p_95855_) {
            super.setSelected(p_95855_);
            CreateFlatWorldScreen.this.updateButtonValidity();
        }

        public void resetRows() {
            int $$0 = this.children().indexOf(this.getSelected());
            this.clearEntries();
            for (int $$1 = 0; $$1 < CreateFlatWorldScreen.this.generator.getLayersInfo().size(); ++$$1) {
                this.addEntry(new Entry());
            }
            List $$2 = this.children();
            if ($$0 >= 0 && $$0 < $$2.size()) {
                this.setSelected((Entry)$$2.get($$0));
            }
        }

        class Entry
        extends ObjectSelectionList.Entry<Entry> {
            Entry() {
            }

            @Override
            public void render(GuiGraphics p_281319_, int p_281943_, int p_283629_, int p_283315_, int p_282974_, int p_281870_, int p_283341_, int p_281639_, boolean p_282715_, float p_281937_) {
                MutableComponent $$15;
                FlatLayerInfo $$10 = CreateFlatWorldScreen.this.generator.getLayersInfo().get(CreateFlatWorldScreen.this.generator.getLayersInfo().size() - p_281943_ - 1);
                BlockState $$11 = $$10.getBlockState();
                ItemStack $$12 = this.getDisplayItem($$11);
                this.blitSlot(p_281319_, p_283315_, p_283629_, $$12);
                p_281319_.drawString(CreateFlatWorldScreen.this.font, $$12.getHoverName(), p_283315_ + 18 + 5, p_283629_ + 3, 0xFFFFFF, false);
                if (p_281943_ == 0) {
                    MutableComponent $$13 = Component.translatable("createWorld.customize.flat.layer.top", $$10.getHeight());
                } else if (p_281943_ == CreateFlatWorldScreen.this.generator.getLayersInfo().size() - 1) {
                    MutableComponent $$14 = Component.translatable("createWorld.customize.flat.layer.bottom", $$10.getHeight());
                } else {
                    $$15 = Component.translatable("createWorld.customize.flat.layer", $$10.getHeight());
                }
                p_281319_.drawString(CreateFlatWorldScreen.this.font, $$15, p_283315_ + 2 + 213 - CreateFlatWorldScreen.this.font.width($$15), p_283629_ + 3, 0xFFFFFF, false);
            }

            private ItemStack getDisplayItem(BlockState p_169294_) {
                Item $$1 = p_169294_.getBlock().asItem();
                if ($$1 == Items.AIR) {
                    if (p_169294_.is(Blocks.WATER)) {
                        $$1 = Items.WATER_BUCKET;
                    } else if (p_169294_.is(Blocks.LAVA)) {
                        $$1 = Items.LAVA_BUCKET;
                    }
                }
                return new ItemStack($$1);
            }

            @Override
            public Component getNarration() {
                FlatLayerInfo $$0 = CreateFlatWorldScreen.this.generator.getLayersInfo().get(CreateFlatWorldScreen.this.generator.getLayersInfo().size() - DetailsList.this.children().indexOf(this) - 1);
                ItemStack $$1 = this.getDisplayItem($$0.getBlockState());
                if (!$$1.isEmpty()) {
                    return Component.translatable("narrator.select", $$1.getHoverName());
                }
                return CommonComponents.EMPTY;
            }

            @Override
            public boolean mouseClicked(double p_95868_, double p_95869_, int p_95870_) {
                DetailsList.this.setSelected(this);
                return super.mouseClicked(p_95868_, p_95869_, p_95870_);
            }

            private void blitSlot(GuiGraphics p_281733_, int p_282373_, int p_282844_, ItemStack p_281263_) {
                this.blitSlotBg(p_281733_, p_282373_ + 1, p_282844_ + 1);
                if (!p_281263_.isEmpty()) {
                    p_281733_.renderFakeItem(p_281263_, p_282373_ + 2, p_282844_ + 2);
                }
            }

            private void blitSlotBg(GuiGraphics p_282271_, int p_281324_, int p_283171_) {
                p_282271_.blitSprite(SLOT_SPRITE, p_281324_, p_283171_, 0, 18, 18);
            }
        }
    }
}

