/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import net.minecraft.client.model.ModelUtils;
import net.minecraft.client.model.QuadrupedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.animal.Panda;

public class PandaModel<T extends Panda>
extends QuadrupedModel<T> {
    private float sitAmount;
    private float lieOnBackAmount;
    private float rollAmount;

    public PandaModel(ModelPart p_170771_) {
        super(p_170771_, true, 23.0f, 4.8f, 2.7f, 3.0f, 49);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition $$0 = new MeshDefinition();
        PartDefinition $$1 = $$0.getRoot();
        $$1.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 6).addBox(-6.5f, -5.0f, -4.0f, 13.0f, 10.0f, 9.0f).texOffs(45, 16).addBox("nose", -3.5f, 0.0f, -6.0f, 7.0f, 5.0f, 2.0f).texOffs(52, 25).addBox("left_ear", 3.5f, -8.0f, -1.0f, 5.0f, 4.0f, 1.0f).texOffs(52, 25).addBox("right_ear", -8.5f, -8.0f, -1.0f, 5.0f, 4.0f, 1.0f), PartPose.offset(0.0f, 11.5f, -17.0f));
        $$1.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 25).addBox(-9.5f, -13.0f, -6.5f, 19.0f, 26.0f, 13.0f), PartPose.offsetAndRotation(0.0f, 10.0f, 0.0f, 1.5707964f, 0.0f, 0.0f));
        int $$2 = 9;
        int $$3 = 6;
        CubeListBuilder $$4 = CubeListBuilder.create().texOffs(40, 0).addBox(-3.0f, 0.0f, -3.0f, 6.0f, 9.0f, 6.0f);
        $$1.addOrReplaceChild("right_hind_leg", $$4, PartPose.offset(-5.5f, 15.0f, 9.0f));
        $$1.addOrReplaceChild("left_hind_leg", $$4, PartPose.offset(5.5f, 15.0f, 9.0f));
        $$1.addOrReplaceChild("right_front_leg", $$4, PartPose.offset(-5.5f, 15.0f, -9.0f));
        $$1.addOrReplaceChild("left_front_leg", $$4, PartPose.offset(5.5f, 15.0f, -9.0f));
        return LayerDefinition.create($$0, 64, 64);
    }

    @Override
    public void prepareMobModel(T p_103173_, float p_103174_, float p_103175_, float p_103176_) {
        super.prepareMobModel(p_103173_, p_103174_, p_103175_, p_103176_);
        this.sitAmount = ((Panda)p_103173_).getSitAmount(p_103176_);
        this.lieOnBackAmount = ((Panda)p_103173_).getLieOnBackAmount(p_103176_);
        this.rollAmount = ((AgeableMob)p_103173_).isBaby() ? 0.0f : ((Panda)p_103173_).getRollAmount(p_103176_);
    }

    @Override
    public void setupAnim(T p_103178_, float p_103179_, float p_103180_, float p_103181_, float p_103182_, float p_103183_) {
        super.setupAnim(p_103178_, p_103179_, p_103180_, p_103181_, p_103182_, p_103183_);
        boolean $$6 = ((Panda)p_103178_).getUnhappyCounter() > 0;
        boolean $$7 = ((Panda)p_103178_).isSneezing();
        int $$8 = ((Panda)p_103178_).getSneezeCounter();
        boolean $$9 = ((Panda)p_103178_).isEating();
        boolean $$10 = ((Panda)p_103178_).isScared();
        if ($$6) {
            this.head.yRot = 0.35f * Mth.sin(0.6f * p_103181_);
            this.head.zRot = 0.35f * Mth.sin(0.6f * p_103181_);
            this.rightFrontLeg.xRot = -0.75f * Mth.sin(0.3f * p_103181_);
            this.leftFrontLeg.xRot = 0.75f * Mth.sin(0.3f * p_103181_);
        } else {
            this.head.zRot = 0.0f;
        }
        if ($$7) {
            if ($$8 < 15) {
                this.head.xRot = -0.7853982f * (float)$$8 / 14.0f;
            } else if ($$8 < 20) {
                float $$11 = ($$8 - 15) / 5;
                this.head.xRot = -0.7853982f + 0.7853982f * $$11;
            }
        }
        if (this.sitAmount > 0.0f) {
            this.body.xRot = ModelUtils.rotlerpRad(this.body.xRot, 1.7407963f, this.sitAmount);
            this.head.xRot = ModelUtils.rotlerpRad(this.head.xRot, 1.5707964f, this.sitAmount);
            this.rightFrontLeg.zRot = -0.27079642f;
            this.leftFrontLeg.zRot = 0.27079642f;
            this.rightHindLeg.zRot = 0.5707964f;
            this.leftHindLeg.zRot = -0.5707964f;
            if ($$9) {
                this.head.xRot = 1.5707964f + 0.2f * Mth.sin(p_103181_ * 0.6f);
                this.rightFrontLeg.xRot = -0.4f - 0.2f * Mth.sin(p_103181_ * 0.6f);
                this.leftFrontLeg.xRot = -0.4f - 0.2f * Mth.sin(p_103181_ * 0.6f);
            }
            if ($$10) {
                this.head.xRot = 2.1707964f;
                this.rightFrontLeg.xRot = -0.9f;
                this.leftFrontLeg.xRot = -0.9f;
            }
        } else {
            this.rightHindLeg.zRot = 0.0f;
            this.leftHindLeg.zRot = 0.0f;
            this.rightFrontLeg.zRot = 0.0f;
            this.leftFrontLeg.zRot = 0.0f;
        }
        if (this.lieOnBackAmount > 0.0f) {
            this.rightHindLeg.xRot = -0.6f * Mth.sin(p_103181_ * 0.15f);
            this.leftHindLeg.xRot = 0.6f * Mth.sin(p_103181_ * 0.15f);
            this.rightFrontLeg.xRot = 0.3f * Mth.sin(p_103181_ * 0.25f);
            this.leftFrontLeg.xRot = -0.3f * Mth.sin(p_103181_ * 0.25f);
            this.head.xRot = ModelUtils.rotlerpRad(this.head.xRot, 1.5707964f, this.lieOnBackAmount);
        }
        if (this.rollAmount > 0.0f) {
            this.head.xRot = ModelUtils.rotlerpRad(this.head.xRot, 2.0561945f, this.rollAmount);
            this.rightHindLeg.xRot = -0.5f * Mth.sin(p_103181_ * 0.5f);
            this.leftHindLeg.xRot = 0.5f * Mth.sin(p_103181_ * 0.5f);
            this.rightFrontLeg.xRot = 0.5f * Mth.sin(p_103181_ * 0.5f);
            this.leftFrontLeg.xRot = -0.5f * Mth.sin(p_103181_ * 0.5f);
        }
    }
}

