/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import org.joml.Vector3f;

public class ItemModelGenerator {
    public static final List<String> LAYERS = Lists.newArrayList((Object[])new String[]{"layer0", "layer1", "layer2", "layer3", "layer4"});
    private static final float MIN_Z = 7.5f;
    private static final float MAX_Z = 8.5f;

    public BlockModel generateBlockModel(Function<Material, TextureAtlasSprite> p_111671_, BlockModel p_111672_) {
        String $$5;
        HashMap $$2 = Maps.newHashMap();
        ArrayList $$3 = Lists.newArrayList();
        for (int $$4 = 0; $$4 < LAYERS.size() && p_111672_.hasTexture($$5 = LAYERS.get($$4)); ++$$4) {
            Material $$6 = p_111672_.getMaterial($$5);
            $$2.put($$5, Either.left((Object)$$6));
            SpriteContents $$7 = p_111671_.apply($$6).contents();
            $$3.addAll(this.processFrames($$4, $$5, $$7));
        }
        $$2.put("particle", p_111672_.hasTexture("particle") ? Either.left((Object)p_111672_.getMaterial("particle")) : (Either)$$2.get("layer0"));
        BlockModel $$8 = new BlockModel(null, $$3, $$2, false, p_111672_.getGuiLight(), p_111672_.getTransforms(), p_111672_.getOverrides());
        $$8.name = p_111672_.name;
        return $$8;
    }

    private List<BlockElement> processFrames(int p_111639_, String p_111640_, SpriteContents p_251768_) {
        HashMap $$3 = Maps.newHashMap();
        $$3.put(Direction.SOUTH, new BlockElementFace(null, p_111639_, p_111640_, new BlockFaceUV(new float[]{0.0f, 0.0f, 16.0f, 16.0f}, 0)));
        $$3.put(Direction.NORTH, new BlockElementFace(null, p_111639_, p_111640_, new BlockFaceUV(new float[]{16.0f, 0.0f, 0.0f, 16.0f}, 0)));
        ArrayList $$4 = Lists.newArrayList();
        $$4.add(new BlockElement(new Vector3f(0.0f, 0.0f, 7.5f), new Vector3f(16.0f, 16.0f, 8.5f), $$3, null, true));
        $$4.addAll(this.createSideElements(p_251768_, p_111640_, p_111639_));
        return $$4;
    }

    private List<BlockElement> createSideElements(SpriteContents p_248810_, String p_111663_, int p_111664_) {
        float $$3 = p_248810_.width();
        float $$4 = p_248810_.height();
        ArrayList $$5 = Lists.newArrayList();
        for (Span $$6 : this.getSpans(p_248810_)) {
            float $$7 = 0.0f;
            float $$8 = 0.0f;
            float $$9 = 0.0f;
            float $$10 = 0.0f;
            float $$11 = 0.0f;
            float $$12 = 0.0f;
            float $$13 = 0.0f;
            float $$14 = 0.0f;
            float $$15 = 16.0f / $$3;
            float $$16 = 16.0f / $$4;
            float $$17 = $$6.getMin();
            float $$18 = $$6.getMax();
            float $$19 = $$6.getAnchor();
            SpanFacing $$20 = $$6.getFacing();
            switch ($$20.ordinal()) {
                case 0: {
                    $$7 = $$11 = $$17;
                    $$9 = $$12 = $$18 + 1.0f;
                    $$8 = $$13 = $$19;
                    $$10 = $$19;
                    $$14 = $$19 + 1.0f;
                    break;
                }
                case 1: {
                    $$13 = $$19;
                    $$14 = $$19 + 1.0f;
                    $$7 = $$11 = $$17;
                    $$9 = $$12 = $$18 + 1.0f;
                    $$8 = $$19 + 1.0f;
                    $$10 = $$19 + 1.0f;
                    break;
                }
                case 2: {
                    $$7 = $$11 = $$19;
                    $$9 = $$19;
                    $$12 = $$19 + 1.0f;
                    $$8 = $$14 = $$17;
                    $$10 = $$13 = $$18 + 1.0f;
                    break;
                }
                case 3: {
                    $$11 = $$19;
                    $$12 = $$19 + 1.0f;
                    $$7 = $$19 + 1.0f;
                    $$9 = $$19 + 1.0f;
                    $$8 = $$14 = $$17;
                    $$10 = $$13 = $$18 + 1.0f;
                }
            }
            $$7 *= $$15;
            $$9 *= $$15;
            $$8 *= $$16;
            $$10 *= $$16;
            $$8 = 16.0f - $$8;
            $$10 = 16.0f - $$10;
            HashMap $$21 = Maps.newHashMap();
            $$21.put($$20.getDirection(), new BlockElementFace(null, p_111664_, p_111663_, new BlockFaceUV(new float[]{$$11 *= $$15, $$13 *= $$16, $$12 *= $$15, $$14 *= $$16}, 0)));
            switch ($$20.ordinal()) {
                case 0: {
                    $$5.add(new BlockElement(new Vector3f($$7, $$8, 7.5f), new Vector3f($$9, $$8, 8.5f), $$21, null, true));
                    break;
                }
                case 1: {
                    $$5.add(new BlockElement(new Vector3f($$7, $$10, 7.5f), new Vector3f($$9, $$10, 8.5f), $$21, null, true));
                    break;
                }
                case 2: {
                    $$5.add(new BlockElement(new Vector3f($$7, $$8, 7.5f), new Vector3f($$7, $$10, 8.5f), $$21, null, true));
                    break;
                }
                case 3: {
                    $$5.add(new BlockElement(new Vector3f($$9, $$8, 7.5f), new Vector3f($$9, $$10, 8.5f), $$21, null, true));
                }
            }
        }
        return $$5;
    }

    private List<Span> getSpans(SpriteContents p_250338_) {
        int $$1 = p_250338_.width();
        int $$2 = p_250338_.height();
        ArrayList $$3 = Lists.newArrayList();
        p_250338_.getUniqueFrames().forEach(p_173444_ -> {
            for (int $$5 = 0; $$5 < $$2; ++$$5) {
                for (int $$6 = 0; $$6 < $$1; ++$$6) {
                    boolean $$7 = !this.isTransparent(p_250338_, p_173444_, $$6, $$5, $$1, $$2);
                    this.checkTransition(SpanFacing.UP, $$3, p_250338_, p_173444_, $$6, $$5, $$1, $$2, $$7);
                    this.checkTransition(SpanFacing.DOWN, $$3, p_250338_, p_173444_, $$6, $$5, $$1, $$2, $$7);
                    this.checkTransition(SpanFacing.LEFT, $$3, p_250338_, p_173444_, $$6, $$5, $$1, $$2, $$7);
                    this.checkTransition(SpanFacing.RIGHT, $$3, p_250338_, p_173444_, $$6, $$5, $$1, $$2, $$7);
                }
            }
        });
        return $$3;
    }

    private void checkTransition(SpanFacing p_251572_, List<Span> p_248882_, SpriteContents p_249847_, int p_250616_, int p_251416_, int p_249664_, int p_250174_, int p_250897_, boolean p_248773_) {
        boolean $$9;
        boolean bl = $$9 = this.isTransparent(p_249847_, p_250616_, p_251416_ + p_251572_.getXOffset(), p_249664_ + p_251572_.getYOffset(), p_250174_, p_250897_) && p_248773_;
        if ($$9) {
            this.createOrExpandSpan(p_248882_, p_251572_, p_251416_, p_249664_);
        }
    }

    private void createOrExpandSpan(List<Span> p_111666_, SpanFacing p_111667_, int p_111668_, int p_111669_) {
        int $$8;
        Span $$4 = null;
        for (Span $$5 : p_111666_) {
            int $$6;
            if ($$5.getFacing() != p_111667_) continue;
            int n = $$6 = p_111667_.isHorizontal() ? p_111669_ : p_111668_;
            if ($$5.getAnchor() != $$6) continue;
            $$4 = $$5;
            break;
        }
        int $$7 = p_111667_.isHorizontal() ? p_111669_ : p_111668_;
        int n = $$8 = p_111667_.isHorizontal() ? p_111668_ : p_111669_;
        if ($$4 == null) {
            p_111666_.add(new Span(p_111667_, $$8, $$7));
        } else {
            $$4.expand($$8);
        }
    }

    private boolean isTransparent(SpriteContents p_249650_, int p_250692_, int p_251914_, int p_252343_, int p_250258_, int p_248997_) {
        if (p_251914_ < 0 || p_252343_ < 0 || p_251914_ >= p_250258_ || p_252343_ >= p_248997_) {
            return true;
        }
        return p_249650_.isTransparent(p_250692_, p_251914_, p_252343_);
    }

    static class Span {
        private final SpanFacing facing;
        private int min;
        private int max;
        private final int anchor;

        public Span(SpanFacing p_111680_, int p_111681_, int p_111682_) {
            this.facing = p_111680_;
            this.min = p_111681_;
            this.max = p_111681_;
            this.anchor = p_111682_;
        }

        public void expand(int p_111685_) {
            if (p_111685_ < this.min) {
                this.min = p_111685_;
            } else if (p_111685_ > this.max) {
                this.max = p_111685_;
            }
        }

        public SpanFacing getFacing() {
            return this.facing;
        }

        public int getMin() {
            return this.min;
        }

        public int getMax() {
            return this.max;
        }

        public int getAnchor() {
            return this.anchor;
        }
    }

    static enum SpanFacing {
        UP(Direction.UP, 0, -1),
        DOWN(Direction.DOWN, 0, 1),
        LEFT(Direction.EAST, -1, 0),
        RIGHT(Direction.WEST, 1, 0);

        private final Direction direction;
        private final int xOffset;
        private final int yOffset;

        private SpanFacing(Direction p_111701_, int p_111702_, int p_111703_) {
            this.direction = p_111701_;
            this.xOffset = p_111702_;
            this.yOffset = p_111703_;
        }

        public Direction getDirection() {
            return this.direction;
        }

        public int getXOffset() {
            return this.xOffset;
        }

        public int getYOffset() {
            return this.yOffset;
        }

        boolean isHorizontal() {
            return this == DOWN || this == UP;
        }
    }
}

