/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import java.util.Arrays;
import java.util.Collection;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.ParserUtils;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;

public class ComponentArgument
implements ArgumentType<Component> {
    private static final Collection<String> EXAMPLES = Arrays.asList("\"hello world\"", "\"\"", "\"{\"text\":\"hello world\"}", "[\"\"]");
    public static final DynamicCommandExceptionType ERROR_INVALID_JSON = new DynamicCommandExceptionType(p_304083_ -> Component.translatableEscape("argument.component.invalid", p_304083_));
    private final HolderLookup.Provider registries;

    private ComponentArgument(HolderLookup.Provider p_323707_) {
        this.registries = p_323707_;
    }

    public static Component getComponent(CommandContext<CommandSourceStack> p_87118_, String p_87119_) {
        return (Component)p_87118_.getArgument(p_87119_, Component.class);
    }

    public static ComponentArgument textComponent(CommandBuildContext p_324401_) {
        return new ComponentArgument(p_324401_);
    }

    public Component parse(StringReader p_87116_) throws CommandSyntaxException {
        try {
            return ParserUtils.parseJson(this.registries, p_87116_, ComponentSerialization.CODEC);
        }
        catch (Exception $$1) {
            String $$2 = $$1.getCause() != null ? $$1.getCause().getMessage() : $$1.getMessage();
            throw ERROR_INVALID_JSON.createWithContext((ImmutableStringReader)p_87116_, (Object)$$2);
        }
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }
}

