/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.advancements;

import it.unimi.dsi.fastutil.Stack;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementNode;
import net.minecraft.advancements.DisplayInfo;

public class AdvancementVisibilityEvaluator {
    private static final int VISIBILITY_DEPTH = 2;

    private static VisibilityRule evaluateVisibilityRule(Advancement p_265736_, boolean p_265426_) {
        Optional<DisplayInfo> $$2 = p_265736_.display();
        if ($$2.isEmpty()) {
            return VisibilityRule.HIDE;
        }
        if (p_265426_) {
            return VisibilityRule.SHOW;
        }
        if ($$2.get().isHidden()) {
            return VisibilityRule.HIDE;
        }
        return VisibilityRule.NO_CHANGE;
    }

    private static boolean evaluateVisiblityForUnfinishedNode(Stack<VisibilityRule> p_265343_) {
        for (int $$1 = 0; $$1 <= 2; ++$$1) {
            VisibilityRule $$2 = (VisibilityRule)((Object)p_265343_.peek($$1));
            if ($$2 == VisibilityRule.SHOW) {
                return true;
            }
            if ($$2 != VisibilityRule.HIDE) continue;
            return false;
        }
        return false;
    }

    private static boolean evaluateVisibility(AdvancementNode p_301282_, Stack<VisibilityRule> p_301009_, Predicate<AdvancementNode> p_265359_, Output p_265303_) {
        boolean $$4 = p_265359_.test(p_301282_);
        VisibilityRule $$5 = AdvancementVisibilityEvaluator.evaluateVisibilityRule(p_301282_.advancement(), $$4);
        boolean $$6 = $$4;
        p_301009_.push((Object)$$5);
        for (AdvancementNode $$7 : p_301282_.children()) {
            $$6 |= AdvancementVisibilityEvaluator.evaluateVisibility($$7, p_301009_, p_265359_, p_265303_);
        }
        boolean $$8 = $$6 || AdvancementVisibilityEvaluator.evaluateVisiblityForUnfinishedNode(p_301009_);
        p_301009_.pop();
        p_265303_.accept(p_301282_, $$8);
        return $$6;
    }

    public static void evaluateVisibility(AdvancementNode p_301203_, Predicate<AdvancementNode> p_265561_, Output p_265381_) {
        AdvancementNode $$3 = p_301203_.root();
        ObjectArrayList $$4 = new ObjectArrayList();
        for (int $$5 = 0; $$5 <= 2; ++$$5) {
            $$4.push((Object)VisibilityRule.NO_CHANGE);
        }
        AdvancementVisibilityEvaluator.evaluateVisibility($$3, (Stack<VisibilityRule>)$$4, p_265561_, p_265381_);
    }

    static enum VisibilityRule {
        SHOW,
        HIDE,
        NO_CHANGE;

    }

    @FunctionalInterface
    public static interface Output {
        public void accept(AdvancementNode var1, boolean var2);
    }
}

