/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddExperienceOrbPacket;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ExperienceOrb
extends Entity {
    private static final int LIFETIME = 6000;
    private static final int ENTITY_SCAN_PERIOD = 20;
    private static final int MAX_FOLLOW_DIST = 8;
    private static final int ORB_GROUPS_PER_AREA = 40;
    private static final double ORB_MERGE_DISTANCE = 0.5;
    private int age;
    private int health = 5;
    private int value;
    private int count = 1;
    private Player followingPlayer;

    public ExperienceOrb(Level p_20776_, double p_20777_, double p_20778_, double p_20779_, int p_20780_) {
        this((EntityType<? extends ExperienceOrb>)EntityType.EXPERIENCE_ORB, p_20776_);
        this.setPos(p_20777_, p_20778_, p_20779_);
        this.setYRot((float)(this.random.nextDouble() * 360.0));
        this.setDeltaMovement((this.random.nextDouble() * (double)0.2f - (double)0.1f) * 2.0, this.random.nextDouble() * 0.2 * 2.0, (this.random.nextDouble() * (double)0.2f - (double)0.1f) * 2.0);
        this.value = p_20780_;
    }

    public ExperienceOrb(EntityType<? extends ExperienceOrb> p_20773_, Level p_20774_) {
        super(p_20773_, p_20774_);
    }

    @Override
    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder p_325930_) {
    }

    @Override
    protected double getDefaultGravity() {
        return 0.03;
    }

    @Override
    public void tick() {
        Vec3 $$0;
        double $$1;
        super.tick();
        this.xo = this.getX();
        this.yo = this.getY();
        this.zo = this.getZ();
        if (this.isEyeInFluid(FluidTags.WATER)) {
            this.setUnderwaterMovement();
        } else {
            this.applyGravity();
        }
        if (this.level().getFluidState(this.blockPosition()).is(FluidTags.LAVA)) {
            this.setDeltaMovement((this.random.nextFloat() - this.random.nextFloat()) * 0.2f, 0.2f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f);
        }
        if (!this.level().noCollision(this.getBoundingBox())) {
            this.moveTowardsClosestSpace(this.getX(), (this.getBoundingBox().minY + this.getBoundingBox().maxY) / 2.0, this.getZ());
        }
        if (this.tickCount % 20 == 1) {
            this.scanForEntities();
        }
        if (this.followingPlayer != null && (this.followingPlayer.isSpectator() || this.followingPlayer.isDeadOrDying())) {
            this.followingPlayer = null;
        }
        if (this.followingPlayer != null && ($$1 = ($$0 = new Vec3(this.followingPlayer.getX() - this.getX(), this.followingPlayer.getY() + (double)this.followingPlayer.getEyeHeight() / 2.0 - this.getY(), this.followingPlayer.getZ() - this.getZ())).lengthSqr()) < 64.0) {
            double $$2 = 1.0 - Math.sqrt($$1) / 8.0;
            this.setDeltaMovement(this.getDeltaMovement().add($$0.normalize().scale($$2 * $$2 * 0.1)));
        }
        this.move(MoverType.SELF, this.getDeltaMovement());
        float $$3 = 0.98f;
        if (this.onGround()) {
            $$3 = this.level().getBlockState(this.getBlockPosBelowThatAffectsMyMovement()).getBlock().getFriction() * 0.98f;
        }
        this.setDeltaMovement(this.getDeltaMovement().multiply($$3, 0.98, $$3));
        if (this.onGround()) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, -0.9, 1.0));
        }
        ++this.age;
        if (this.age >= 6000) {
            this.discard();
        }
    }

    @Override
    public BlockPos getBlockPosBelowThatAffectsMyMovement() {
        return this.getOnPos(0.999999f);
    }

    private void scanForEntities() {
        if (this.followingPlayer == null || this.followingPlayer.distanceToSqr(this) > 64.0) {
            this.followingPlayer = this.level().getNearestPlayer(this, 8.0);
        }
        if (this.level() instanceof ServerLevel) {
            List<ExperienceOrb> $$0 = this.level().getEntities(EntityTypeTest.forClass(ExperienceOrb.class), this.getBoundingBox().inflate(0.5), this::canMerge);
            for (ExperienceOrb $$1 : $$0) {
                this.merge($$1);
            }
        }
    }

    public static void award(ServerLevel p_147083_, Vec3 p_147084_, int p_147085_) {
        while (p_147085_ > 0) {
            int $$3 = ExperienceOrb.getExperienceValue(p_147085_);
            p_147085_ -= $$3;
            if (ExperienceOrb.tryMergeToExisting(p_147083_, p_147084_, $$3)) continue;
            p_147083_.addFreshEntity(new ExperienceOrb(p_147083_, p_147084_.x(), p_147084_.y(), p_147084_.z(), $$3));
        }
    }

    private static boolean tryMergeToExisting(ServerLevel p_147097_, Vec3 p_147098_, int p_147099_) {
        AABB $$3 = AABB.ofSize(p_147098_, 1.0, 1.0, 1.0);
        int $$4 = p_147097_.getRandom().nextInt(40);
        List<ExperienceOrb> $$5 = p_147097_.getEntities(EntityTypeTest.forClass(ExperienceOrb.class), $$3, p_147081_ -> ExperienceOrb.canMerge(p_147081_, $$4, p_147099_));
        if (!$$5.isEmpty()) {
            ExperienceOrb $$6 = $$5.get(0);
            ++$$6.count;
            $$6.age = 0;
            return true;
        }
        return false;
    }

    private boolean canMerge(ExperienceOrb p_147087_) {
        return p_147087_ != this && ExperienceOrb.canMerge(p_147087_, this.getId(), this.value);
    }

    private static boolean canMerge(ExperienceOrb p_147089_, int p_147090_, int p_147091_) {
        return !p_147089_.isRemoved() && (p_147089_.getId() - p_147090_) % 40 == 0 && p_147089_.value == p_147091_;
    }

    private void merge(ExperienceOrb p_147101_) {
        this.count += p_147101_.count;
        this.age = Math.min(this.age, p_147101_.age);
        p_147101_.discard();
    }

    private void setUnderwaterMovement() {
        Vec3 $$0 = this.getDeltaMovement();
        this.setDeltaMovement($$0.x * (double)0.99f, Math.min($$0.y + (double)5.0E-4f, (double)0.06f), $$0.z * (double)0.99f);
    }

    @Override
    protected void doWaterSplashEffect() {
    }

    @Override
    public boolean hurt(DamageSource p_20785_, float p_20786_) {
        if (this.isInvulnerableTo(p_20785_)) {
            return false;
        }
        if (this.level().isClientSide) {
            return true;
        }
        this.markHurt();
        this.health = (int)((float)this.health - p_20786_);
        if (this.health <= 0) {
            this.discard();
        }
        return true;
    }

    @Override
    public void addAdditionalSaveData(CompoundTag p_20796_) {
        p_20796_.putShort("Health", (short)this.health);
        p_20796_.putShort("Age", (short)this.age);
        p_20796_.putShort("Value", (short)this.value);
        p_20796_.putInt("Count", this.count);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag p_20788_) {
        this.health = p_20788_.getShort("Health");
        this.age = p_20788_.getShort("Age");
        this.value = p_20788_.getShort("Value");
        this.count = Math.max(p_20788_.getInt("Count"), 1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void playerTouch(Player p_20792_) {
        if (!(p_20792_ instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer $$1 = (ServerPlayer)p_20792_;
        if (p_20792_.takeXpDelay == 0) {
            void $$2;
            p_20792_.takeXpDelay = 2;
            p_20792_.take(this, 1);
            int $$3 = this.repairPlayerItems((ServerPlayer)$$2, this.value);
            if ($$3 > 0) {
                p_20792_.giveExperiencePoints($$3);
            }
            --this.count;
            if (this.count == 0) {
                this.discard();
            }
        }
    }

    private int repairPlayerItems(ServerPlayer p_344821_, int p_147094_) {
        Optional<EnchantedItemInUse> $$2 = EnchantmentHelper.getRandomItemWith(EnchantmentEffectComponents.REPAIR_WITH_XP, p_344821_, ItemStack::isDamaged);
        if ($$2.isPresent()) {
            int $$6;
            ItemStack $$3 = $$2.get().itemStack();
            int $$4 = EnchantmentHelper.modifyDurabilityToRepairFromXp(p_344821_.serverLevel(), $$3, p_147094_);
            int $$5 = Math.min($$4, $$3.getDamageValue());
            $$3.setDamageValue($$3.getDamageValue() - $$5);
            if ($$5 > 0 && ($$6 = p_147094_ - $$5 * p_147094_ / $$4) > 0) {
                return this.repairPlayerItems(p_344821_, $$6);
            }
            return 0;
        }
        return p_147094_;
    }

    public int getValue() {
        return this.value;
    }

    public int getIcon() {
        if (this.value >= 2477) {
            return 10;
        }
        if (this.value >= 1237) {
            return 9;
        }
        if (this.value >= 617) {
            return 8;
        }
        if (this.value >= 307) {
            return 7;
        }
        if (this.value >= 149) {
            return 6;
        }
        if (this.value >= 73) {
            return 5;
        }
        if (this.value >= 37) {
            return 4;
        }
        if (this.value >= 17) {
            return 3;
        }
        if (this.value >= 7) {
            return 2;
        }
        if (this.value >= 3) {
            return 1;
        }
        return 0;
    }

    public static int getExperienceValue(int p_20783_) {
        if (p_20783_ >= 2477) {
            return 2477;
        }
        if (p_20783_ >= 1237) {
            return 1237;
        }
        if (p_20783_ >= 617) {
            return 617;
        }
        if (p_20783_ >= 307) {
            return 307;
        }
        if (p_20783_ >= 149) {
            return 149;
        }
        if (p_20783_ >= 73) {
            return 73;
        }
        if (p_20783_ >= 37) {
            return 37;
        }
        if (p_20783_ >= 17) {
            return 17;
        }
        if (p_20783_ >= 7) {
            return 7;
        }
        if (p_20783_ >= 3) {
            return 3;
        }
        return 1;
    }

    @Override
    public boolean isAttackable() {
        return false;
    }

    @Override
    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity p_352351_) {
        return new ClientboundAddExperienceOrbPacket(this, p_352351_);
    }

    @Override
    public SoundSource getSoundSource() {
        return SoundSource.AMBIENT;
    }
}

