/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ThrownEnderpearl
extends ThrowableItemProjectile {
    public ThrownEnderpearl(EntityType<? extends ThrownEnderpearl> p_37491_, Level p_37492_) {
        super((EntityType<? extends ThrowableItemProjectile>)p_37491_, p_37492_);
    }

    public ThrownEnderpearl(Level p_37499_, LivingEntity p_37500_) {
        super((EntityType<? extends ThrowableItemProjectile>)EntityType.ENDER_PEARL, p_37500_, p_37499_);
    }

    @Override
    protected Item getDefaultItem() {
        return Items.ENDER_PEARL;
    }

    @Override
    protected void onHitEntity(EntityHitResult p_37502_) {
        super.onHitEntity(p_37502_);
        p_37502_.getEntity().hurt(this.damageSources().thrown(this, this.getOwner()), 0.0f);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void onHit(HitResult p_37504_) {
        void $$3;
        block12: {
            block11: {
                super.onHit(p_37504_);
                for (int $$1 = 0; $$1 < 32; ++$$1) {
                    this.level().addParticle(ParticleTypes.PORTAL, this.getX(), this.getY() + this.random.nextDouble() * 2.0, this.getZ(), this.random.nextGaussian(), 0.0, this.random.nextGaussian());
                }
                Level level = this.level();
                if (!(level instanceof ServerLevel)) break block11;
                ServerLevel $$2 = (ServerLevel)level;
                if (!this.isRemoved()) break block12;
            }
            return;
        }
        Entity $$4 = this.getOwner();
        if ($$4 == null || !ThrownEnderpearl.isAllowedToTeleportOwner($$4, (Level)$$3)) {
            this.discard();
            return;
        }
        if ($$4.isPassenger()) {
            $$4.unRide();
        }
        if ($$4 instanceof ServerPlayer) {
            ServerPlayer $$5 = (ServerPlayer)$$4;
            if ($$5.connection.isAcceptingMessages()) {
                Endermite $$6;
                if (this.random.nextFloat() < 0.05f && $$3.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING) && ($$6 = EntityType.ENDERMITE.create((Level)$$3)) != null) {
                    $$6.moveTo($$4.getX(), $$4.getY(), $$4.getZ(), $$4.getYRot(), $$4.getXRot());
                    $$3.addFreshEntity($$6);
                }
                $$4.changeDimension(new DimensionTransition((ServerLevel)$$3, this.position(), $$4.getDeltaMovement(), $$4.getYRot(), $$4.getXRot(), DimensionTransition.DO_NOTHING));
                $$4.resetFallDistance();
                $$5.resetCurrentImpulseContext();
                $$4.hurt(this.damageSources().fall(), 5.0f);
                this.playSound((Level)$$3, this.position());
            }
        } else {
            $$4.changeDimension(new DimensionTransition((ServerLevel)$$3, this.position(), $$4.getDeltaMovement(), $$4.getYRot(), $$4.getXRot(), DimensionTransition.DO_NOTHING));
            $$4.resetFallDistance();
            this.playSound((Level)$$3, this.position());
        }
        this.discard();
    }

    private static boolean isAllowedToTeleportOwner(Entity p_352055_, Level p_352453_) {
        if (p_352055_.level().dimension() == p_352453_.dimension()) {
            if (p_352055_ instanceof LivingEntity) {
                LivingEntity $$2 = (LivingEntity)p_352055_;
                return $$2.isAlive() && !$$2.isSleeping();
            }
            return p_352055_.isAlive();
        }
        return p_352055_.canUsePortal(true);
    }

    @Override
    public void tick() {
        Entity $$0 = this.getOwner();
        if ($$0 instanceof ServerPlayer && !$$0.isAlive() && this.level().getGameRules().getBoolean(GameRules.RULE_ENDER_PEARLS_VANISH_ON_DEATH)) {
            this.discard();
        } else {
            super.tick();
        }
    }

    private void playSound(Level p_350706_, Vec3 p_350543_) {
        p_350706_.playSound(null, p_350543_.x, p_350543_.y, p_350543_.z, SoundEvents.PLAYER_TELEPORT, SoundSource.PLAYERS);
    }

    @Override
    public boolean canChangeDimensions(Level p_352941_, Level p_352929_) {
        Entity entity;
        if (p_352941_.dimension() == Level.END && (entity = this.getOwner()) instanceof ServerPlayer) {
            ServerPlayer $$2 = (ServerPlayer)entity;
            return super.canChangeDimensions(p_352941_, p_352929_) && $$2.seenCredits;
        }
        return super.canChangeDimensions(p_352941_, p_352929_);
    }

    @Override
    protected void onInsideBlock(BlockState p_353066_) {
        Entity entity;
        super.onInsideBlock(p_353066_);
        if (p_353066_.is(Blocks.END_GATEWAY) && (entity = this.getOwner()) instanceof ServerPlayer) {
            ServerPlayer $$1 = (ServerPlayer)entity;
            $$1.onInsideBlock(p_353066_);
        }
    }
}

