/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.ae2addonlib.api;

import appeng.api.features.IGridLinkableHandler;
import appeng.api.ids.AEComponents;
import appeng.api.implementations.blockentities.IWirelessAccessPoint;
import appeng.api.networking.IGrid;
import appeng.core.localization.PlayerMessages;
import appeng.util.Platform;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public interface IGridLinkedItem {
    public static final IGridLinkableHandler LINKABLE_HANDLER = new LinkableHandler();

    @Nullable
    default public GlobalPos getLinkedPosition(ItemStack item) {
        return (GlobalPos)item.get(AEComponents.WIRELESS_LINK_TARGET);
    }

    @Nullable
    default public IGrid getLinkedGrid(ItemStack stack, Level level) {
        return this.getLinkedGrid(stack, level, null);
    }

    @Nullable
    default public IGrid getLinkedGrid(ItemStack stack, Level level, @Nullable Consumer<Component> errorConsumer) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            GlobalPos linkedPos = this.getLinkedPosition(stack);
            if (linkedPos == null) {
                if (errorConsumer != null) {
                    errorConsumer.accept((Component)PlayerMessages.DeviceNotLinked.text());
                }
                return null;
            }
            ServerLevel linkedLevel = serverLevel.getServer().getLevel(linkedPos.dimension());
            if (linkedLevel == null) {
                if (errorConsumer != null) {
                    errorConsumer.accept((Component)PlayerMessages.LinkedNetworkNotFound.text());
                }
                return null;
            }
            BlockEntity be = Platform.getTickingBlockEntity((Level)linkedLevel, (BlockPos)linkedPos.pos());
            if (be instanceof IWirelessAccessPoint) {
                IWirelessAccessPoint accessPoint = (IWirelessAccessPoint)be;
                IGrid grid = accessPoint.getGrid();
                if (grid == null && errorConsumer != null) {
                    errorConsumer.accept((Component)PlayerMessages.LinkedNetworkNotFound.text());
                }
                return grid;
            }
            if (errorConsumer != null) {
                errorConsumer.accept((Component)PlayerMessages.LinkedNetworkNotFound.text());
            }
            return null;
        }
        return null;
    }

    public static final class LinkableHandler
    implements IGridLinkableHandler {
        public boolean canLink(ItemStack stack) {
            return stack.getItem() instanceof IGridLinkedItem;
        }

        public void link(ItemStack itemStack, GlobalPos pos) {
            itemStack.set(AEComponents.WIRELESS_LINK_TARGET, (Object)pos);
        }

        public void unlink(ItemStack itemStack) {
            itemStack.remove(AEComponents.WIRELESS_LINK_TARGET);
        }
    }
}

