/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.ae2addonlib.client.widgets;

import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEKey;
import appeng.client.gui.MathExpressionParser;
import appeng.client.gui.NumberEntryType;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.ConfirmableTextField;
import appeng.core.localization.GuiText;
import com.google.common.primitives.Longs;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class NumberTextField
extends ConfirmableTextField {
    private static final int PADDING = 10;
    private static final int TEXT_COLOR = 0xFFFFFF;
    private static final int ERROR_COLOR = 0xFF0000;
    private final DecimalFormat decimalFormat;
    private NumberEntryType type = NumberEntryType.UNITLESS;
    private final long minValue = 0L;
    private final long maxValue = Long.MAX_VALUE;
    private boolean isFluid;
    private long lastLongValue = 0L;
    private final Component tooltip;

    public NumberTextField(ScreenStyle style, int x, int y, int width, int height, Consumer<Long> onConfirm, Component tooltip) {
        super(style, Minecraft.getInstance().font, x, y, width, height);
        this.decimalFormat = new DecimalFormat("#.######", new DecimalFormatSymbols());
        this.decimalFormat.setParseBigDecimal(true);
        this.decimalFormat.setNegativePrefix("-");
        this.tooltip = tooltip;
        this.setBordered(false);
        this.setMaxLength(25);
        this.setTextColor(0xFFFFFF);
        this.setSelectionColor(-16777088);
        this.setVisible(true);
        this.setResponder(text -> this.validate());
        this.setOnConfirm(() -> {
            if (this.getLongValue().isPresent()) {
                this.lastLongValue = this.getLongValue().getAsLong();
                onConfirm.accept(this.getLongValue().getAsLong());
            }
        });
        this.validate();
    }

    public boolean isChanged() {
        if (this.getLongValue().isPresent()) {
            return this.lastLongValue != this.getLongValue().getAsLong();
        }
        return true;
    }

    public OptionalInt getIntValue() {
        OptionalLong value = this.getLongValue();
        if (value.isPresent()) {
            long longValue = value.getAsLong();
            if (longValue > Integer.MAX_VALUE) {
                return OptionalInt.empty();
            }
            return OptionalInt.of((int)longValue);
        }
        return OptionalInt.empty();
    }

    public OptionalLong getLongValue() {
        Optional<BigDecimal> internalValue = this.getValueInternal();
        if (internalValue.isEmpty()) {
            return OptionalLong.empty();
        }
        if (this.type.amountPerUnit() == 1 && internalValue.get().scale() > 0) {
            return OptionalLong.empty();
        }
        long externalValue = this.convertToExternalValue(internalValue.get());
        if (externalValue < 0L) {
            return OptionalLong.empty();
        }
        if (externalValue > Long.MAX_VALUE) {
            return OptionalLong.empty();
        }
        return OptionalLong.of(externalValue);
    }

    public void setLongValue(long value) {
        this.lastLongValue = value;
        BigDecimal internalValue = this.convertToInternalValue(Longs.constrainToRange((long)value, (long)0L, (long)Long.MAX_VALUE));
        this.setValue(this.decimalFormat.format(internalValue));
        this.moveCursorToEnd(false);
        this.setHighlightPos(0);
        this.validate();
    }

    private Optional<BigDecimal> getValueInternal() {
        String textValue = this.getValue();
        if (textValue.startsWith("=")) {
            textValue = textValue.substring(1);
        }
        return MathExpressionParser.parse((String)textValue, (DecimalFormat)this.decimalFormat);
    }

    private boolean isNumber() {
        ParsePosition position = new ParsePosition(0);
        String textValue = this.getValue().trim();
        this.decimalFormat.parse(textValue, position);
        return position.getErrorIndex() == -1 && position.getIndex() == textValue.length();
    }

    private void setValueInternal(BigDecimal value) {
        this.setValue(this.decimalFormat.format(value));
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partial) {
        super.renderWidget(guiGraphics, mouseX, mouseY, partial);
        if (!this.isFluid) {
            return;
        }
        guiGraphics.drawString(Minecraft.getInstance().font, "B", this.getX() + this.width - 10, this.getY(), 0xFFFFFF, false);
    }

    private void validate() {
        ArrayList<Object> tooltip;
        ArrayList<MutableComponent> validationErrors = new ArrayList<MutableComponent>();
        ArrayList<Object> infoMessages = new ArrayList<Object>();
        Optional<BigDecimal> possibleValue = this.getValueInternal();
        if (possibleValue.isPresent()) {
            if (this.type.amountPerUnit() == 1 && possibleValue.get().scale() > 0) {
                validationErrors.add(GuiText.NumberNonInteger.text());
            } else {
                long value = this.convertToExternalValue(possibleValue.get());
                if (value < 0L) {
                    String formatted = this.decimalFormat.format(this.convertToInternalValue(0L));
                    validationErrors.add(GuiText.NumberLessThanMinValue.text(new Object[]{formatted}));
                } else if (value > Long.MAX_VALUE) {
                    String formatted = this.decimalFormat.format(this.convertToInternalValue(Long.MAX_VALUE));
                    validationErrors.add(GuiText.NumberGreaterThanMaxValue.text(new Object[]{formatted}));
                } else if (!this.isNumber()) {
                    infoMessages.add(Component.literal((String)("= " + this.decimalFormat.format(possibleValue.get()))));
                }
            }
        } else {
            validationErrors.add(GuiText.InvalidNumber.text());
        }
        boolean valid = validationErrors.isEmpty();
        ArrayList<Object> arrayList = tooltip = valid ? infoMessages : validationErrors;
        if (tooltip.isEmpty()) {
            tooltip.add(this.tooltip);
        }
        this.setTextColor(valid ? 0xFFFFFF : 0xFF0000);
        this.setTooltipMessage(tooltip);
    }

    private long convertToExternalValue(BigDecimal internalValue) {
        BigDecimal multiplicand = BigDecimal.valueOf(this.type.amountPerUnit());
        BigDecimal value = internalValue.multiply(multiplicand, MathContext.DECIMAL128);
        value = value.setScale(0, RoundingMode.UP);
        return value.longValue();
    }

    private BigDecimal convertToInternalValue(long externalValue) {
        BigDecimal divisor = BigDecimal.valueOf(this.type.amountPerUnit());
        return BigDecimal.valueOf(externalValue).divide(divisor, MathContext.DECIMAL128);
    }

    void adjustToType(@Nullable AEKey key) {
        this.isFluid = key instanceof AEFluidKey;
        this.type = NumberEntryType.of((AEKey)key);
        if (this.isFluid) {
            this.setWidth(this.width - 10 - 10);
        } else {
            this.setWidth(this.width - 10);
        }
    }
}

